/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class OVParameterAreaMenu
implements MenuListener,
SelectionListener {
    protected Table myParameter;
    protected Menu myMenu;
    protected StyledText styledText;
    protected MenuItem saveItem;
    protected MenuItem printItem;
    protected MenuItem menuSeparator1;

    public OVParameterAreaMenu(Table aTable) {
        this.myParameter = aTable;
        this.myMenu = new Menu((Control)this.myParameter);
        this.saveItem = new MenuItem(this.myMenu, 0);
        this.saveItem.setText(OutputViewPlugin.getString("OV_MESSAGE_SAVE_AS"));
        this.menuSeparator1 = new MenuItem(this.myMenu, 2);
        this.printItem = new MenuItem(this.myMenu, 0);
        this.printItem.setText(OutputViewPlugin.getString("OV_MESSAGE_PRINT"));
        this.listenAll();
    }

    private void listenAll() {
        this.myMenu.addMenuListener((MenuListener)this);
        this.saveItem.addSelectionListener((SelectionListener)this);
        this.printItem.addSelectionListener((SelectionListener)this);
    }

    public Menu getMenu() {
        return this.myMenu;
    }

    private void saveOutput() {
        FileDialog fileDialog = new FileDialog(this.myParameter.getShell(), 8192);
        String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.isDirectory()) {
                    this.displayDirectoryError(this.myParameter.getShell(), fileName);
                    return;
                }
                if (file.exists()) {
                    Object[] obj = new Object[]{fileName};
                    String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_DESC", obj);
                    MessageBox box = new MessageBox(this.myParameter.getShell(), 192);
                    box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_TITLE"));
                    box.setMessage(message);
                    if (box.open() != 64) {
                        return;
                    }
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                int columnCount = this.myParameter.getColumnCount();
                int i = 0;
                while (i < columnCount) {
                    bw.write(this.myParameter.getColumn(i).getText());
                    bw.write(9);
                    ++i;
                }
                bw.newLine();
                int itemCount = this.myParameter.getItemCount();
                int i2 = 0;
                while (i2 < itemCount) {
                    int j = 0;
                    while (j < columnCount) {
                        bw.write(this.myParameter.getItem(i2).getText(j));
                        bw.write(9);
                        ++j;
                    }
                    bw.newLine();
                    ++i2;
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                MessageBox box = new MessageBox(this.myParameter.getShell(), 1);
                box.setText(OutputViewPlugin.getString("OV_STATUS_ERROR"));
                box.setMessage(ex.getMessage());
                box.open();
            }
        }
    }

    protected void displayDirectoryError(Shell aShell, String aFile) {
        Object[] obj = new Object[]{aFile};
        String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_DESC", obj);
        MessageBox box = new MessageBox(aShell, 33);
        box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_TITLE"));
        box.setMessage(message);
        box.open();
        this.saveOutput();
    }

    protected void printOutput() {
        PrintDialog dialog = new PrintDialog(this.myParameter.getShell(), 0);
        PrinterData printerData = dialog.open();
        if (printerData != null) {
            Printer printer = new Printer(printerData);
            StringBuffer sb = new StringBuffer(2000);
            int columnCount = this.myParameter.getColumnCount();
            String lineSeparator = System.getProperty("line.separator");
            int i = 0;
            while (i < columnCount) {
                sb.append(this.myParameter.getColumn(i).getText());
                sb.append('\t');
                ++i;
            }
            sb.append(lineSeparator);
            int itemCount = this.myParameter.getItemCount();
            int i2 = 0;
            while (i2 < itemCount) {
                int j = 0;
                while (j < columnCount) {
                    sb.append(this.myParameter.getItem(i2).getText(j));
                    sb.append('\t');
                    ++j;
                }
                sb.append(lineSeparator);
                ++i2;
            }
            if (this.styledText == null) {
                this.styledText = new StyledText((Composite)this.myParameter, 64);
                this.styledText.setVisible(false);
            }
            this.styledText.setText(sb.toString());
            this.styledText.print(printer).run();
            printer.dispose();
        }
    }

    public void menuHidden(MenuEvent anEvent) {
    }

    public void menuShown(MenuEvent anEvent) {
        this.saveItem.setEnabled(this.myParameter.getItemCount() > 0);
        this.printItem.setEnabled(this.myParameter.getItemCount() > 0);
    }

    public void widgetDefaultSelected(SelectionEvent anEvent) {
    }

    public void widgetSelected(SelectionEvent anEvent) {
        Object source = anEvent.getSource();
        if (source == this.saveItem) {
            this.saveOutput();
        } else if (source == this.printItem) {
            this.printOutput();
        }
    }
}

