/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.application.ApplicationTranslator;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class ApplicationResourceImpl
extends XMLResourceImpl
implements ApplicationResource {
    public ApplicationResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public ApplicationResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public Application getApplication() {
        return (Application)this.getRootObject();
    }

    public int getType() {
        return 2;
    }

    public String getDoctype() {
        switch (this.getJ2EEVersionID()) {
            case 12: 
            case 13: {
                return "application";
            }
        }
        return null;
    }

    public int getJ2EEVersionID() {
        return this.getModuleVersionID();
    }

    public Translator getRootTranslator() {
        return ApplicationTranslator.INSTANCE;
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/application_1_3.dtd";
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    }

    public void setModuleVersionID(int id) {
        super.setVersionID(id);
        switch (id) {
            case 14: {
                super.setDoctypeValues(null, null);
                break;
            }
            case 13: {
                super.setDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                break;
            }
            case 12: {
                super.setDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            }
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int id) {
        this.primSetVersionID(id);
        switch (id) {
            case 14: {
                this.primSetDoctypeValues(null, null);
                break;
            }
            case 13: {
                this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                break;
            }
            case 12: {
                this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            }
        }
        this.syncVersionOfRootObject();
    }

    protected void syncVersionOfRootObject() {
        Application app = this.getApplication();
        if (app == null) {
            return;
        }
        String version = app.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            app.setVersion(newVersion);
        }
    }
}

