/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;
import org.eclipse.jst.j2ee.internal.deploy.J2EEDeployOperation;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEDeployAction
extends BaseAction {
    protected void primRun(Shell shell) {
        if (this.isEnabled()) {
            final IStructuredSelection deploySelection = this.selection;
            Job deployJob = new Job("Deploy"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus result = null;
                    J2EEDeployOperation op = new J2EEDeployOperation(deploySelection.toArray());
                    try {
                        result = op.execute(monitor, null);
                    }
                    catch (Exception e) {
                        result = new Status(4, "org.eclipse.wst.common.frameworks", 4, WTPResourceHandler.getString((String)"27"), (Throwable)e);
                        Logger.getLogger().logError((Throwable)e);
                    }
                    return result;
                }
            };
            try {
                deployJob.setUser(true);
                deployJob.schedule();
            }
            catch (Exception exception) {}
        }
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        super.selectionChanged(action, aSelection);
        action.setEnabled(this.isEnabled());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnabled() {
        try {
            DeployerRegistry reg = DeployerRegistry.instance();
            List modules = DeployerRegistry.getSelectedModules((Object[])this.selection.toArray());
            int i = 0;
            while (true) {
                if (i >= modules.size()) {
                    return false;
                }
                EObject module = (EObject)modules.get(i);
                IProject proj = ProjectUtilities.getProject((EObject)module);
                IRuntime runtime = J2EEProjectUtilities.getServerRuntime((IProject)proj);
                if (proj == null || runtime == null) {
                    return false;
                }
                List visitors = reg.getDeployModuleExtensions(module, runtime);
                if (!visitors.isEmpty()) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            System.out.println("Deploy Action recovering from problem verifying enablement.");
            e.printStackTrace();
            return false;
        }
    }
}

