/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.NameCollector;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabels;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class PromoteTempToFieldRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    public static final int INITIALIZE_IN_FIELD = 0;
    public static final int INITIALIZE_IN_METHOD = 1;
    public static final int INITIALIZE_IN_CONSTRUCTOR = 2;
    private String fFieldName;
    private int fVisibility;
    private boolean fDeclareStatic;
    private boolean fDeclareFinal;
    private int fInitializeIn;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private boolean fInitializerUsesLocalTypes;
    private boolean fTempTypeUsesClassTypeVariables;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private PromoteTempToFieldRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings codeGenerationSettings) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        Assert.isNotNull(codeGenerationSettings);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fCodeGenerationSettings = codeGenerationSettings;
    }

    public static PromoteTempToFieldRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings codeGenerationSettings) {
        return new PromoteTempToFieldRefactoring(cu, selectionStart, selectionLength, codeGenerationSettings);
    }

    public String getName() {
        return RefactoringCoreMessages.PromoteTempToFieldRefactoring_name;
    }

    public int[] getAvailableVisibilities() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public int getInitializeIn() {
        return this.fInitializeIn;
    }

    public void setVisibility(int accessModifier) {
        Assert.isTrue(accessModifier == 2 || accessModifier == 0 || accessModifier == 4 || accessModifier == 1);
        this.fVisibility = accessModifier;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public void setFieldName(String fieldName) {
        Assert.isNotNull(fieldName);
        this.fFieldName = fieldName;
    }

    public void setInitializeIn(int initializeIn) {
        Assert.isTrue(initializeIn == 2 || initializeIn == 0 || initializeIn == 1);
        this.fInitializeIn = initializeIn;
    }

    public boolean canEnableSettingStatic() {
        return this.fInitializeIn != 2 && !this.isTempDeclaredInStaticMethod() && !this.fTempTypeUsesClassTypeVariables;
    }

    public boolean canEnableSettingFinal() {
        if (this.fInitializeIn == 2) {
            return this.canEnableSettingDeclareInConstructors() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.fInitializeIn == 0) {
            return this.canEnableSettingDeclareInFieldDeclaration() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        return false;
    }

    private boolean tempHasAssignmentsOtherThanInitialization() {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclarationNode);
        this.fCompilationUnitNode.accept((ASTVisitor)assignmentFinder);
        return assignmentFinder.hasAssignments();
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return !this.fDeclareStatic && !this.fInitializerUsesLocalTypes && !this.getMethodDeclaration().isConstructor() && !this.isDeclaredInAnonymousClass() && !this.isTempDeclaredInStaticMethod() && this.tempHasInitializer();
    }

    public boolean canEnableSettingDeclareInMethod() {
        return !this.fDeclareFinal && this.tempHasInitializer();
    }

    private boolean tempHasInitializer() {
        return this.getTempInitializer() != null;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return !this.fInitializerUsesLocalTypes && this.tempHasInitializer();
    }

    private Expression getTempInitializer() {
        return this.fTempDeclarationNode.getInitializer();
    }

    private boolean isTempDeclaredInStaticMethod() {
        return Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
    }

    private MethodDeclaration getMethodDeclaration() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz);
    }

    private boolean isDeclaredInAnonymousClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz) != null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fTempDeclarationNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_only_declared_in_methods);
        }
        if (this.isMethodParameter()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_method_parameters);
        }
        if (this.isTempAnExceptionInCatchBlock()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_exceptions);
        }
        result.merge(this.checkTempTypeForLocalTypeUsage());
        if (result.hasFatalError()) {
            return result;
        }
        this.checkTempInitializerForLocalTypeUsage();
        this.initializeDefaults();
        return result;
    }

    private void initializeDefaults() {
        this.fVisibility = 2;
        this.fDeclareStatic = Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
        this.fDeclareFinal = false;
        if (this.canEnableSettingDeclareInMethod()) {
            this.fInitializeIn = 1;
        } else if (this.canEnableSettingDeclareInFieldDeclaration()) {
            this.fInitializeIn = 0;
        } else if (this.canEnableSettingDeclareInConstructors()) {
            this.fInitializeIn = 2;
        }
        this.fFieldName = this.getInitialFieldName();
    }

    public String[] guessFieldNames() {
        String tempName = this.fTempDeclarationNode.getName().getIdentifier();
        String rawTempName = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)this.fCu.getJavaProject(), (String)tempName);
        String[] excludedNames = this.getNamesOfFieldsInDeclaringType();
        int dim = this.getTempTypeArrayDimensions();
        String[] suggestedNames = StubUtility.getFieldNameSuggestions(this.fCu.getJavaProject(), rawTempName, dim, this.getModifiers(), excludedNames);
        return suggestedNames;
    }

    private String getInitialFieldName() {
        String[] suggestedNames = this.guessFieldNames();
        if (suggestedNames.length > 0) {
            String longest = suggestedNames[0];
            int i = 1;
            while (i < suggestedNames.length) {
                if (suggestedNames[i].length() > longest.length()) {
                    longest = suggestedNames[i];
                }
                ++i;
            }
            return longest;
        }
        return this.fTempDeclarationNode.getName().getIdentifier();
    }

    private String[] getNamesOfFieldsInDeclaringType() {
        AbstractTypeDeclaration type = this.getEnclosingType();
        if (type instanceof TypeDeclaration) {
            FieldDeclaration[] fields = ((TypeDeclaration)type).getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                Iterator iter = fields[i].fragments().iterator();
                while (iter.hasNext()) {
                    VariableDeclarationFragment field = (VariableDeclarationFragment)iter.next();
                    result.add(field.getName().getIdentifier());
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    private int getTempTypeArrayDimensions() {
        int dim = 0;
        Type tempType = this.getTempDeclarationStatement().getType();
        if (tempType.isArrayType()) {
            dim += ((ArrayType)tempType).getDimensions();
        }
        return dim += this.fTempDeclarationNode.getExtraDimensions();
    }

    private void checkTempInitializerForLocalTypeUsage() {
        Expression initializer = this.fTempDeclarationNode.getInitializer();
        if (initializer == null) {
            return;
        }
        ITypeBinding[] methodTypeParameters = this.getMethodDeclaration().resolveBinding().getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer localTypeAnalyer = new LocalTypeAndVariableUsageAnalyzer(methodTypeParameters);
        initializer.accept((ASTVisitor)localTypeAnalyer);
        this.fInitializerUsesLocalTypes = !localTypeAnalyer.getUsageOfEnclosingNodes().isEmpty();
    }

    private RefactoringStatus checkTempTypeForLocalTypeUsage() {
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        if (vds == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        Type type = vds.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        ITypeBinding[] methodTypeParameters = this.getMethodDeclaration().resolveBinding().getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer analyzer = new LocalTypeAndVariableUsageAnalyzer(methodTypeParameters);
        type.accept((ASTVisitor)analyzer);
        boolean usesLocalTypes = !analyzer.getUsageOfEnclosingNodes().isEmpty();
        this.fTempTypeUsesClassTypeVariables = analyzer.getClassTypeVariablesUsed();
        if (usesLocalTypes) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_uses_type_declared_locally);
        }
        return null;
    }

    private VariableDeclarationStatement getTempDeclarationStatement() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (VariableDeclarationStatement)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz);
    }

    private boolean isTempAnExceptionInCatchBlock() {
        return this.fTempDeclarationNode.getParent() instanceof CatchClause;
    }

    private boolean isMethodParameter() {
        return this.fTempDeclarationNode.getParent() instanceof MethodDeclaration;
    }

    private void initAST(IProgressMonitor pm) {
        this.fCompilationUnitNode = new RefactoringASTParser(3).parse(this.fCu, true, pm);
        this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
    }

    public RefactoringStatus validateInput() {
        return Checks.checkFieldName(this.fFieldName);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkClashesWithExistingFields());
            if (this.fInitializeIn == 2) {
                result.merge(this.checkClashesInConstructors());
            }
            refactoringStatus = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkClashesInConstructors() {
        Assert.isTrue(this.fInitializeIn == 2);
        Assert.isTrue(!this.isDeclaredInAnonymousClass());
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        if (declaration instanceof TypeDeclaration) {
            MethodDeclaration[] methods = ((TypeDeclaration)declaration).getMethods();
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                if (method.isConstructor()) {
                    NameCollector nameCollector = new NameCollector((ASTNode)method){

                        protected boolean visitNode(ASTNode node) {
                            return true;
                        }
                    };
                    method.accept((ASTVisitor)nameCollector);
                    List names = nameCollector.getNames();
                    if (names.contains(this.fFieldName)) {
                        Object[] keys = new String[]{this.fFieldName, BindingLabels.getFullyQualified((IBinding)method.resolveBinding())};
                        String msg = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict, keys);
                        return RefactoringStatus.createFatalErrorStatus((String)msg);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private RefactoringStatus checkClashesWithExistingFields() {
        FieldDeclaration[] existingFields = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        int i = 0;
        while (i < existingFields.length) {
            FieldDeclaration declaration = existingFields[i];
            VariableDeclarationFragment[] fragments = declaration.fragments().toArray(new VariableDeclarationFragment[declaration.fragments().size()]);
            int j = 0;
            while (j < fragments.length) {
                VariableDeclarationFragment fragment = fragments[j];
                if (this.fFieldName.equals(fragment.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create(this.fCu, (ASTNode)fragment);
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict_with_field, (RefactoringStatusContext)context);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private ChildListPropertyDescriptor getBodyDeclarationListOfDeclaringType() {
        ASTNode methodParent = this.getMethodDeclaration().getParent();
        if (methodParent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)methodParent).getBodyDeclarationsProperty();
        }
        if (methodParent instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue(false);
        return null;
    }

    private FieldDeclaration[] getFieldDeclarations(ChildListPropertyDescriptor descriptor) {
        List bodyDeclarations = (List)this.getMethodDeclaration().getParent().getStructuralProperty((StructuralPropertyDescriptor)descriptor);
        ArrayList fields = new ArrayList(1);
        Iterator iter = bodyDeclarations.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof FieldDeclaration)) continue;
            fields.add(each);
        }
        return fields.toArray(new FieldDeclaration[fields.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Change change;
        pm.beginTask("", 1);
        try {
            ASTRewrite rewrite = ASTRewrite.create((AST)this.fCompilationUnitNode.getAST());
            if (this.fInitializeIn == 1 && this.tempHasInitializer()) {
                this.addLocalDeclarationSplit(rewrite);
            } else {
                this.addLocalDeclarationRemoval(rewrite);
            }
            if (this.fInitializeIn == 2) {
                this.addInitializersToConstructors(rewrite);
            }
            if (!this.fFieldName.equals(this.fTempDeclarationNode.getName().getIdentifier())) {
                this.addTempRenames(rewrite);
            }
            this.addFieldDeclaration(rewrite);
            change = this.createChange(rewrite);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    private void addTempRenames(ASTRewrite rewrite) {
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, false);
        analyzer.perform();
        SimpleName[] tempRefs = analyzer.getReferenceNodes();
        int j = 0;
        while (j < tempRefs.length) {
            SimpleName occurence = tempRefs[j];
            SimpleName newName = this.getAST().newSimpleName(this.fFieldName);
            rewrite.replace((ASTNode)occurence, (ASTNode)newName, null);
            ++j;
        }
    }

    private void addInitializersToConstructors(ASTRewrite rewrite) throws CoreException {
        Assert.isTrue(!this.isDeclaredInAnonymousClass());
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        MethodDeclaration[] constructors = PromoteTempToFieldRefactoring.getAllConstructors(declaration);
        if (constructors.length == 0) {
            this.addNewConstructorWithInitializing(rewrite, declaration);
        } else {
            int index = 0;
            while (index < constructors.length) {
                if (PromoteTempToFieldRefactoring.shouldInsertTempInitialization(constructors[index])) {
                    this.addFieldInitializationToConstructor(rewrite, constructors[index]);
                }
                ++index;
            }
        }
    }

    private void addNewConstructorWithInitializing(ASTRewrite rewrite, AbstractTypeDeclaration declaration) throws CoreException {
        String constructorSource = CodeFormatterUtil.format(4, this.getNewConstructorSource(declaration), 0, null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu), this.fCu.getJavaProject());
        BodyDeclaration newConstructor = (BodyDeclaration)rewrite.createStringPlaceholder(constructorSource, 31);
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newConstructor, this.computeInsertIndexForNewConstructor(declaration), null);
    }

    private String getEnclosingTypeName() {
        return this.getEnclosingType().getName().getIdentifier();
    }

    private AbstractTypeDeclaration getEnclosingType() {
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)variableDeclarationStatement, clazz);
    }

    private String getNewConstructorSource(AbstractTypeDeclaration declaration) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu);
        String bodyStatement = String.valueOf(this.fFieldName) + '=' + this.getTempInitializerCode() + ';';
        String constructorBody = CodeGeneration.getMethodBodyContent(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), true, bodyStatement, lineDelimiter);
        if (constructorBody == null) {
            constructorBody = "";
        }
        return String.valueOf(this.getNewConstructorComment()) + JdtFlags.getVisibilityString(declaration.getModifiers()) + ' ' + this.getEnclosingTypeName() + '(' + "){" + lineDelimiter + constructorBody + lineDelimiter + '}';
    }

    private String getNewConstructorComment() throws CoreException {
        if (this.fCodeGenerationSettings.createComments) {
            String comment = CodeGeneration.getMethodComment(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), new String[0], new String[0], null, null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu));
            if (comment == null) {
                return "";
            }
            return String.valueOf(comment) + StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu);
        }
        return "";
    }

    private int computeInsertIndexForNewConstructor(AbstractTypeDeclaration declaration) {
        List declarations = declaration.bodyDeclarations();
        if (declarations.isEmpty()) {
            return 0;
        }
        int index = this.findFirstMethodIndex(declaration);
        if (index == -1) {
            return declarations.size();
        }
        return index;
    }

    private int findFirstMethodIndex(AbstractTypeDeclaration typeDeclaration) {
        int i = 0;
        int n = typeDeclaration.bodyDeclarations().size();
        while (i < n) {
            if (typeDeclaration.bodyDeclarations().get(i) instanceof MethodDeclaration) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addFieldInitializationToConstructor(ASTRewrite rewrite, MethodDeclaration constructor) throws JavaModelException {
        if (constructor.getBody() == null) {
            constructor.setBody(this.getAST().newBlock());
        }
        rewrite.getListRewrite((ASTNode)constructor.getBody(), Block.STATEMENTS_PROPERTY).insertLast((ASTNode)this.createExpressionStatementThatInitializesField(rewrite), null);
    }

    private static boolean shouldInsertTempInitialization(MethodDeclaration constructor) {
        Assert.isTrue(constructor.isConstructor());
        if (constructor.getBody() == null) {
            return false;
        }
        List statements = constructor.getBody().statements();
        if (statements == null) {
            return false;
        }
        return statements.size() <= 0 || !(statements.get(0) instanceof ConstructorInvocation);
    }

    private static MethodDeclaration[] getAllConstructors(AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof TypeDeclaration) {
            MethodDeclaration[] allMethods = ((TypeDeclaration)typeDeclaration).getMethods();
            ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(Math.min(allMethods.length, 1));
            int i = 0;
            while (i < allMethods.length) {
                MethodDeclaration declaration = allMethods[i];
                if (declaration.isConstructor()) {
                    result.add(declaration);
                }
                ++i;
            }
            return result.toArray(new MethodDeclaration[result.size()]);
        }
        return new MethodDeclaration[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Change createChange(ASTRewrite rewrite) throws CoreException {
        CompilationUnitChange result = new CompilationUnitChange("", this.fCu);
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.fCu);
        try {
            TextEdit resultingEdits = rewrite.rewriteAST(buffer.getDocument(), this.fCu.getJavaProject().getOptions(true));
            TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.PromoteTempToFieldRefactoring_editName, resultingEdits);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            RefactoringFileBuffers.release(this.fCu);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        RefactoringFileBuffers.release(this.fCu);
        return result;
    }

    private void addLocalDeclarationSplit(ASTRewrite rewrite) throws JavaModelException {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        Block block = (Block)tempDeclarationStatement.getParent();
        int statementIndex = block.statements().indexOf(tempDeclarationStatement);
        Assert.isTrue(statementIndex != -1);
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue(fragmentIndex != -1);
        int i1 = fragmentIndex;
        int n = fragments.size();
        while (i1 < n) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i1);
            rewrite.remove((ASTNode)fragment, null);
            ++i1;
        }
        if (fragmentIndex == 0) {
            rewrite.remove((ASTNode)tempDeclarationStatement, null);
        }
        Assert.isTrue(this.tempHasInitializer());
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)this.createExpressionStatementThatInitializesField(rewrite), statementIndex + 1, null);
        if (fragmentIndex + 1 < fragments.size()) {
            VariableDeclarationFragment firstFragmentAfter = (VariableDeclarationFragment)fragments.get(fragmentIndex + 1);
            VariableDeclarationFragment copyfirstFragmentAfter = (VariableDeclarationFragment)rewrite.createCopyTarget((ASTNode)firstFragmentAfter);
            VariableDeclarationStatement statement = this.getAST().newVariableDeclarationStatement(copyfirstFragmentAfter);
            Type type = (Type)rewrite.createCopyTarget((ASTNode)tempDeclarationStatement.getType());
            statement.setType(type);
            List modifiers = tempDeclarationStatement.modifiers();
            if (modifiers.size() > 0) {
                ListRewrite modifiersRewrite = rewrite.getListRewrite((ASTNode)tempDeclarationStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                ASTNode firstModifier = (ASTNode)modifiers.get(0);
                ASTNode lastModifier = (ASTNode)modifiers.get(modifiers.size() - 1);
                ASTNode modifiersCopy = modifiersRewrite.createCopyTarget(firstModifier, lastModifier);
                statement.modifiers().add(modifiersCopy);
            }
            int i = fragmentIndex + 2;
            while (i < fragments.size()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                VariableDeclarationFragment fragmentCopy = (VariableDeclarationFragment)rewrite.createCopyTarget((ASTNode)fragment);
                statement.fragments().add(fragmentCopy);
                ++i;
            }
            rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, statementIndex + 2, null);
        }
    }

    private ExpressionStatement createExpressionStatementThatInitializesField(ASTRewrite rewrite) throws JavaModelException {
        Assignment assignment = this.getAST().newAssignment();
        SimpleName fieldName = this.getAST().newSimpleName(this.fFieldName);
        assignment.setLeftHandSide((Expression)fieldName);
        String initializerCode = this.getTempInitializerCode();
        Expression tempInitializerCopy = (Expression)rewrite.createStringPlaceholder(initializerCode, 32);
        assignment.setRightHandSide(tempInitializerCopy);
        ExpressionStatement assignmentStatement = this.getAST().newExpressionStatement((Expression)assignment);
        return assignmentStatement;
    }

    private String getTempInitializerCode() throws JavaModelException {
        return this.fCu.getBuffer().getText(this.getTempInitializer().getStartPosition(), this.getTempInitializer().getLength());
    }

    private void addLocalDeclarationRemoval(ASTRewrite rewrite) {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue(fragmentIndex != -1);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(fragmentIndex);
        rewrite.remove((ASTNode)fragment, null);
        if (fragments.size() == 1) {
            rewrite.remove((ASTNode)tempDeclarationStatement, null);
        }
    }

    private void addFieldDeclaration(ASTRewrite rewrite) {
        ChildListPropertyDescriptor descriptor = this.getBodyDeclarationListOfDeclaringType();
        FieldDeclaration[] fields = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        ASTNode parent = this.getMethodDeclaration().getParent();
        int insertIndex = fields.length == 0 ? 0 : ((List)parent.getStructuralProperty((StructuralPropertyDescriptor)descriptor)).indexOf(fields[fields.length - 1]) + 1;
        FieldDeclaration declaration = this.createNewFieldDeclaration(rewrite);
        rewrite.getListRewrite(parent, descriptor).insertAt((ASTNode)declaration, insertIndex, null);
    }

    private FieldDeclaration createNewFieldDeclaration(ASTRewrite rewrite) {
        VariableDeclarationFragment fragment = this.getAST().newVariableDeclarationFragment();
        SimpleName variableName = this.getAST().newSimpleName(this.fFieldName);
        fragment.setName(variableName);
        fragment.setExtraDimensions(this.fTempDeclarationNode.getExtraDimensions());
        if (this.fInitializeIn == 0 && this.tempHasInitializer()) {
            Expression initializer = (Expression)rewrite.createCopyTarget((ASTNode)this.getTempInitializer());
            fragment.setInitializer(initializer);
        }
        FieldDeclaration fieldDeclaration = this.getAST().newFieldDeclaration(fragment);
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        Type type = (Type)rewrite.createCopyTarget((ASTNode)vds.getType());
        fieldDeclaration.setType(type);
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.getAST(), this.getModifiers()));
        return fieldDeclaration;
    }

    private int getModifiers() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    private AST getAST() {
        return this.fTempDeclarationNode.getAST();
    }

    private static class LocalTypeAndVariableUsageAnalyzer
    extends HierarchicalASTVisitor {
        private final List fLocalDefinitions = new ArrayList(0);
        private final List fLocalReferencesToEnclosing = new ArrayList(0);
        private final List fMethodTypeVariables;
        private boolean fClassTypeVariablesUsed = false;

        public LocalTypeAndVariableUsageAnalyzer(ITypeBinding[] methodTypeVariables) {
            this.fMethodTypeVariables = Arrays.asList(methodTypeVariables);
        }

        public List getUsageOfEnclosingNodes() {
            return this.fLocalReferencesToEnclosing;
        }

        public boolean getClassTypeVariablesUsed() {
            return this.fClassTypeVariablesUsed;
        }

        public boolean visit(SimpleName node) {
            IBinding binding;
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.isLocal()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            if (typeBinding != null && typeBinding.isTypeVariable()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    if (this.fMethodTypeVariables.contains(typeBinding)) {
                        this.fLocalReferencesToEnclosing.add(node);
                    } else {
                        this.fClassTypeVariablesUsed = true;
                    }
                }
            }
            if ((binding = node.resolveBinding()) != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(binding);
                } else if (!this.fLocalDefinitions.contains(binding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            return super.visit(node);
        }
    }
}

