/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class ArrayType
extends TType {
    private TType fElementType;
    private int fDimensions;
    private TType fErasure;

    protected ArrayType(TypeEnvironment environment) {
        super(environment);
    }

    protected ArrayType(TypeEnvironment environment, String key) {
        super(environment, key);
    }

    protected void initialize(ITypeBinding binding, TType elementType) {
        Assert.isTrue(binding.isArray());
        super.initialize(binding);
        this.fElementType = elementType;
        this.fDimensions = binding.getDimensions();
        this.fErasure = this.fElementType.isStandardType() || this.fElementType.isGenericType() || this.fElementType.isPrimitiveType() ? this : this.getEnvironment().create(binding.getErasure());
    }

    protected void initialize(TType elementType, int dimensions) {
        this.fElementType = elementType;
        this.fDimensions = dimensions;
        this.fErasure = this.fElementType.isStandardType() || this.fElementType.isGenericType() || this.fElementType.isPrimitiveType() ? this : this.getEnvironment().createArrayType(elementType.getErasure(), dimensions);
    }

    public TType getElementType() {
        return this.fElementType;
    }

    public TType getComponentType() {
        if (this.fDimensions > 1) {
            return this.getEnvironment().createArrayType(this.fElementType, this.fDimensions - 1);
        }
        return this.fElementType;
    }

    public int getDimensions() {
        return this.fDimensions;
    }

    public int getKind() {
        return 4;
    }

    public TType[] getSubTypes() {
        TType[] subTypes = this.fElementType.getSubTypes();
        TType[] result = new TType[subTypes.length];
        int i = 0;
        while (i < subTypes.length) {
            result[i] = this.getEnvironment().createArrayType(subTypes[i], this.fDimensions);
            ++i;
        }
        return result;
    }

    public TType getErasure() {
        return this.fErasure;
    }

    public boolean doEquals(TType other) {
        ArrayType arrayType = (ArrayType)other;
        return this.fElementType.equals(arrayType.fElementType) && this.fDimensions == arrayType.fDimensions;
    }

    public int hashCode() {
        return this.fElementType.hashCode() << 5;
    }

    protected boolean doCanAssignTo(TType lhs) {
        switch (lhs.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.canAssignToArrayType((ArrayType)lhs);
            }
            case 6: {
                return false;
            }
            case 5: {
                return this.isArrayLhsCompatible(lhs);
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(lhs);
            }
        }
        return false;
    }

    private boolean canAssignToArrayType(ArrayType lhs) {
        if (this.fDimensions == lhs.fDimensions) {
            if (this.fElementType.getKind() == 3 || lhs.fElementType.getKind() == 3) {
                return this.fElementType.isTypeEquivalentTo(lhs.fElementType);
            }
            return this.fElementType.canAssignTo(lhs.fElementType);
        }
        if (this.fDimensions < lhs.fDimensions) {
            return false;
        }
        return this.isArrayLhsCompatible(lhs.fElementType);
    }

    private boolean isArrayLhsCompatible(TType lhsElementType) {
        return lhsElementType.isJavaLangObject() || lhsElementType.isJavaLangCloneable() || lhsElementType.isJavaIoSerializable();
    }

    protected String getPlainPrettySignature() {
        StringBuffer result = new StringBuffer(this.fElementType.getPlainPrettySignature());
        int i = 0;
        while (i < this.fDimensions) {
            result.append("[]");
            ++i;
        }
        return result.toString();
    }

    public String getName() {
        StringBuffer result = new StringBuffer(this.fElementType.getName());
        int i = 0;
        while (i < this.fDimensions) {
            result.append("[]");
            ++i;
        }
        return result.toString();
    }
}

