/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction() {
        super(JavaEditorMessages.getBundleForConstructedKeys(), "TogglePresentation.", null, 2);
        JavaPluginImages.setToolImageDescriptors((IAction)this, "segment_edit.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.toggle_presentation_action_context");
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IRegion remembered = editor.getHighlightRange();
        editor.resetHighlightRange();
        boolean showAll = !editor.showsHighlightRangeOnly();
        this.setChecked(showAll);
        editor.showHighlightRangeOnly(showAll);
        if (remembered != null) {
            editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("org.eclipse.jdt.ui.editor.showSegments", showAll);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = editor != null && editor.showsHighlightRangeOnly();
        this.setChecked(checked);
        if (editor instanceof CompilationUnitEditor) {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            this.setEnabled(manager.getWorkingCopy(editor.getEditorInput()) != null);
        } else if (editor instanceof ClassFileEditor) {
            IEditorInput input = editor.getEditorInput();
            IClassFile cf = null;
            if (input instanceof IClassFileEditorInput) {
                IClassFileEditorInput cfi = (IClassFileEditorInput)input;
                cf = cfi.getClassFile();
            }
            this.setEnabled(cf != null && cf.exists());
        } else {
            this.setEnabled(editor != null);
        }
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = JavaPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(editor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        boolean showSegments = this.fStore.getBoolean("org.eclipse.jdt.ui.editor.showSegments");
        this.setChecked(showSegments);
        if (editor.showsHighlightRangeOnly() != showSegments) {
            IRegion remembered = editor.getHighlightRange();
            editor.resetHighlightRange();
            editor.showHighlightRangeOnly(showSegments);
            if (remembered != null) {
                editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.jdt.ui.editor.showSegments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

