/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IDropActionDelegate;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonDropActionDelegate;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.CommonDropHandlerService;
import org.eclipse.wst.common.navigator.internal.views.dnd.DropHandlerDescriptor;
import org.eclipse.wst.common.navigator.internal.views.dnd.IDropValidator;
import org.eclipse.wst.common.navigator.internal.views.dnd.ISerializer;
import org.eclipse.wst.common.navigator.internal.views.dnd.NavigatorDropSelectionDialog;
import org.eclipse.wst.common.navigator.internal.views.dnd.NavigatorSelectionSerializer;

public class PluginDropAction
implements IDropActionDelegate {
    private ISerializer serializer;

    public boolean run(Object sourceData, Object target) {
        NavigatorSelectionSerializer.NavigatorSerializedSelection navSelection = (NavigatorSelectionSerializer.NavigatorSerializedSelection)this.getSerializer().fromByteArray((byte[])sourceData);
        CommonDropHandlerService registry = CommonDropHandlerService.getInstance(navSelection.viewerId);
        TransferData transferData = PluginTransfer.getInstance().getSupportedTypes()[0];
        String serializerId = null;
        ICommonDropActionDelegate action = null;
        ArrayList<DropHandlerDescriptor> validatedList = new ArrayList<DropHandlerDescriptor>();
        Hashtable<DropHandlerDescriptor, String> descriptorToSerizliazerIDHash = new Hashtable<DropHandlerDescriptor, String>();
        Iterator keyItr = navSelection.selectionMap.keySet().iterator();
        while (keyItr.hasNext()) {
            serializerId = keyItr.next().toString();
            DropHandlerDescriptor[] descriptors = registry.getDropHandlersBySerializerId(serializerId);
            int i = 0;
            while (i < descriptors.length) {
                IDropValidator validator;
                if (!validatedList.contains(descriptors[i]) && ((validator = descriptors[i].getDropValidator()) == null || validator.validateDrop(null, target, -1, transferData))) {
                    validatedList.add(descriptors[i]);
                    descriptorToSerizliazerIDHash.put(descriptors[i], serializerId);
                }
                ++i;
            }
        }
        IDialogSettings settings = NavigatorPlugin.getDefault().getDialogSettings();
        if (settings.get(NavigatorDropSelectionDialog.SKIP_ON_SINGLE_SELECTION) == null) {
            settings.put(NavigatorDropSelectionDialog.SKIP_ON_SINGLE_SELECTION, true);
        }
        boolean skipOnSingle = settings.getBoolean(NavigatorDropSelectionDialog.SKIP_ON_SINGLE_SELECTION);
        if (validatedList.size() > 0) {
            DropHandlerDescriptor[] validatedDescriptors = new DropHandlerDescriptor[validatedList.size()];
            validatedList.toArray(validatedDescriptors);
            DropHandlerDescriptor descriptorToUse = validatedDescriptors[0];
            if (validatedDescriptors.length != 1 || !skipOnSingle) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                NavigatorDropSelectionDialog dialog = new NavigatorDropSelectionDialog(shell, validatedDescriptors);
                descriptorToUse = dialog.open() == 0 ? dialog.getSelectedDescriptor() : null;
            }
            if (descriptorToUse != null) {
                serializerId = (String)descriptorToSerizliazerIDHash.get(descriptorToUse);
                List objects = (List)navSelection.selectionMap.get(serializerId);
                StructuredSelection selection = new StructuredSelection(objects.toArray());
                action = CommonDropHandlerService.getInstance(navSelection.viewerId).getActionForSerializerId(serializerId);
                action.run(selection, target);
                return true;
            }
        }
        return false;
    }

    protected ISerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new NavigatorSelectionSerializer();
        }
        return this.serializer;
    }
}

