/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EMFExpression {
    private static final String PACKAGE = "package";
    private static final String ATT_URI = "uri";
    private final IConfigurationElement expression;
    private final Set packageURIs;

    public EMFExpression(IConfigurationElement aConfigElement) {
        this.expression = aConfigElement;
        this.packageURIs = new HashSet();
        this.init();
    }

    private void init() {
        String uri = null;
        IConfigurationElement[] packages = this.expression.getChildren(PACKAGE);
        int i = 0;
        while (i < packages.length) {
            uri = packages[i].getAttribute(ATT_URI);
            if (uri != null) {
                this.packageURIs.add(uri);
            }
            ++i;
        }
    }

    public boolean isEnabledFor(Object anElement) {
        if (anElement instanceof EObject) {
            return this.isEnabledFor((EObject)anElement);
        }
        if (anElement instanceof ItemProvider) {
            return this.isEnabledFor(this.findTarget((ItemProvider)anElement));
        }
        if (anElement instanceof IWrapperItemProvider && ((IWrapperItemProvider)anElement).getOwner() instanceof EObject) {
            return this.isEnabledFor((EObject)((IWrapperItemProvider)anElement).getOwner());
        }
        return false;
    }

    public boolean isEnabledFor(IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return false;
        }
        Object element = null;
        Iterator selItr = aSelection.iterator();
        while (selItr.hasNext()) {
            element = selItr.next();
            if (this.isEnabledFor((Object)element)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledFor(EObject anElement) {
        if (anElement != null) {
            return this.packageURIs.contains(anElement.eClass().getEPackage().getNsURI());
        }
        return false;
    }

    private EObject findTarget(ItemProvider anItemProvider) {
        if (anItemProvider.getParent() == null || anItemProvider.getParent() == anItemProvider) {
            return null;
        }
        if (anItemProvider.getParent() instanceof EObject) {
            return (EObject)anItemProvider.getParent();
        }
        if (anItemProvider.getParent() instanceof Adapter) {
            return this.findTarget((Adapter)anItemProvider.getParent());
        }
        if (anItemProvider.getParent() instanceof ItemProvider) {
            return this.findTarget((ItemProvider)anItemProvider.getParent());
        }
        return null;
    }

    private EObject findTarget(Adapter anAdapter) {
        if (anAdapter != null && anAdapter.getTarget() instanceof EObject) {
            return (EObject)anAdapter.getTarget();
        }
        return null;
    }
}

