/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.preferences;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.ui.preferences.ActionDialogPreferenceType;

public class ActionDialogPreferenceTypeRegistry {
    private static ActionDialogPreferenceTypeRegistry instance_;
    private Hashtable typesByName_;

    private void loadDialogsPreferences() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.ui", "actionDialogPreferenceType");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            try {
                Object actionDialogPreferenceType = elem.createExecutableExtension("class");
                if (actionDialogPreferenceType instanceof ActionDialogPreferenceType) {
                    ActionDialogPreferenceType dialog = (ActionDialogPreferenceType)actionDialogPreferenceType;
                    dialog.setId(elem.getAttribute("id"));
                    dialog.setName(elem.getAttribute("name"));
                    dialog.setInfopop(elem.getAttribute("infopop"));
                    dialog.setTooltip(elem.getAttribute("tooltip"));
                    this.add(dialog);
                }
            }
            catch (CoreException coreException) {}
            ++idx;
        }
    }

    private void load() {
        this.typesByName_ = new Hashtable();
        this.loadDialogsPreferences();
    }

    private void add(ActionDialogPreferenceType dialog) {
        this.typesByName_.put(dialog.getId(), dialog);
    }

    public static ActionDialogPreferenceTypeRegistry getInstance() {
        if (instance_ == null) {
            instance_ = new ActionDialogPreferenceTypeRegistry();
            instance_.load();
        }
        return instance_;
    }

    public ActionDialogPreferenceType[] getActionDialogsPrefrences() {
        ActionDialogPreferenceType[] dialogs = new ActionDialogPreferenceType[this.typesByName_.size()];
        Enumeration e = this.typesByName_.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            dialogs[i] = (ActionDialogPreferenceType)e.nextElement();
            ++i;
        }
        return dialogs;
    }

    public ActionDialogPreferenceType getActionDialogPrefrenceTypeByName(String name) {
        return name == null ? null : (ActionDialogPreferenceType)this.typesByName_.get(name);
    }
}

