/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Mar 31, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.workingset.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.HistoryWorkingSetUpdater;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;

/**
 * @author Admin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CommonWorkingSetViewer extends CommonViewer {

	private List fPendingGetChildren;
	private Map fAdditionalMappings;
	private List fItemsBeingRemoved = new ArrayList();
	/**
	 * @param aCommonNavigatorId
	 * @param aParent
	 * @param aStyle
	 */
	public CommonWorkingSetViewer(String aCommonNavigatorId, Composite aParent,
			int aStyle) {
		super(aCommonNavigatorId, aParent, aStyle);
		if (fPendingGetChildren == null)
		fPendingGetChildren= Collections.synchronizedList(new ArrayList());
	}
	

	
	public void add(Object parentElement, Object[] childElements) {
		if (fPendingGetChildren.contains(parentElement)) 
			return;
		// we have to remember the list before we actually do something since
		// the super.add call already modifies the mapping.
		List l= (List)getAdditionalMappings().get(parentElement);
		if (l == null) {
			super.add(parentElement, childElements);
		} else {
			List stable= new ArrayList(l);
			super.add(parentElement, childElements);
			for (Iterator iter= stable.iterator(); iter.hasNext();) {
				Widget item= (Widget)iter.next();
				super.internalAdd(item, parentElement, childElements);				
			}
		}
	}
			
	protected Object[] getRawChildren(Object parent) {
		synchronized (fPendingGetChildren) {
			try {
				fPendingGetChildren.add(parent);
				return super.getRawChildren(parent);				
			} finally {
				fPendingGetChildren.remove(parent);
			}
		}
	}
	
	
	
	/* Checks if a filtered object in essential (ie. is a parent that
	 * should not be removed).
	 */ 
	/*private boolean isEssential(Object object) {
	
		return false;
	}*/
	
	protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
		IStructuredSelection is= (IStructuredSelection)invalidSelection;
		List ns= null;
		if (newSelection instanceof IStructuredSelection) {
			ns= new ArrayList(((IStructuredSelection)newSelection).toList());
		} else {
			ns= new ArrayList();
		}
		boolean changed= false;
		for (Iterator iter= is.iterator(); iter.hasNext();) {
			Object element= iter.next();
		    if (element instanceof IProject) {
				IProject project= (IProject)element;
				if (project.isOpen()) {
					IJavaProject jProject= JavaCore.create(project);
					if (jProject != null && jProject.exists())
						ns.add(jProject);
						changed= true;
				}
			}
		}
		if (changed) {
			newSelection= new StructuredSelection(ns);
			setSelection(newSelection);
		}
		super.handleInvalidSelection(invalidSelection, newSelection);
	}
//	---- sorter per parent support ------
	
	/*protected Object[] getSortedChildren(Object parent) {
		IParentAwareSorter sorter= getSorter() instanceof IParentAwareSorter 
			? (IParentAwareSorter)getSorter()
			: null;
		if (sorter != null)
			sorter.setParent(parent);
		try {
			return super.getSortedChildren(parent);
		} finally {
			if (sorter != null)
				sorter.setParent(null);
		}
	}*/
	//---- support for multiple elements in tree
	
	
	protected void mapElement(Object element, Widget item) {
		Widget existingItem= findItem(element);
		if (existingItem == null || existingItem == item) {
			super.mapElement(element, item);
		} else {
			List l= (List)getAdditionalMappings().get(element);
			if (l == null) {
				l= new ArrayList();
				getAdditionalMappings().put(element, l);
			}
			if (!l.contains(item)) {
				l.add(item);
				fResourceToItemsMapper.addToMap(element, (Item)item);
			}
		}
	}
	protected void unmapElement(Object element, Widget item) {
		List l= (List)getAdditionalMappings().get(element);
		if (l == null) {
			super.unmapElement(element, item);
			return;
		}
		if (findItem(element) == item) {
			super.unmapElement(element, item);
			if (l != null && l.size() >= 1) {
				Widget widget= (Widget)l.remove(0);
				fResourceToItemsMapper.removeFromMap(element, (Item)widget);
				super.mapElement(element, widget);
			}
		} else {
			l.remove(item);
			fResourceToItemsMapper.removeFromMap(element, (Item) item);
		}
		if (l.size() == 0)
			getAdditionalMappings().remove(element);
	}
	protected void unmapAllElements() {
		getAdditionalMappings().clear();
		super.unmapAllElements();
	}
	
	
	public void remove(Object[] elements) {
		fItemsBeingRemoved.clear();
		fItemsBeingRemoved.addAll(Arrays.asList(elements));
		super.removeWithoutRefresh(elements);
	
		List stillExisting= new ArrayList();
		do {
			stillExisting.clear();
			for (int i= 0; i < elements.length; i++) {
				if (findItem(elements[i]) != null)
					stillExisting.add(elements[i]);
			}
			if (stillExisting.size() > 0) {
				fItemsBeingRemoved.clear();
				fItemsBeingRemoved.addAll(stillExisting);
				super.removeWithoutRefresh(stillExisting.toArray());
			}
		} while (stillExisting.size() > 0);
		ITreeContentProvider contentProvider = (ITreeContentProvider) getContentProvider();
		for (int i = 0; i < elements.length; i++) {
			super.internalRefresh(contentProvider.getParent(elements[i]));
		}
	}
	private Map getAdditionalMappings() {
		if (fAdditionalMappings == null) {
			fAdditionalMappings = new HashMap();
			fPendingGetChildren= Collections.synchronizedList(new ArrayList());
		}
		return fAdditionalMappings;
	}
	protected void internalRefresh(Object element, boolean updateLabels) {
		
		List l= (List)getAdditionalMappings().get(element);
		if (l == null) {
			super.internalRefresh(element, updateLabels);
		} else {
			List stable= new ArrayList(l);
			super.internalRefresh(element, updateLabels);
			for (Iterator iter= stable.iterator(); iter.hasNext();) {
				Widget item= (Widget)iter.next();
				super.internalRefresh(item, element, true, updateLabels);				
			}
		}
	}
	protected void internalUpdate(Widget item, Object element, String[] properties) {
		
		List l= (List)getAdditionalMappings().get(element);
		if (l == null) {
			if (!item.isDisposed())
			 super.internalUpdate(item, element, properties);
			else {
				System.out.println("Widget Disposed");
			}
		} else {
			List stable= new ArrayList(l);
			super.internalUpdate(item, element, properties);
			for (Iterator iter= stable.iterator(); iter.hasNext();) {
				Widget additionalItem= (Widget)iter.next();
				super.internalUpdate(additionalItem, element, properties);
			}
		}
	}
	public ISelection getSelection() {
		IContentProvider cp= getContentProvider();
		if (!(cp instanceof IMultiElementTreeContentProvider)) {
			return super.getSelection();
		}
		Control control = getControl();
		if (control == null || control.isDisposed()) {
			return StructuredSelection.EMPTY;
		}
		Tree tree= getTree();
		TreeItem[] selection= tree.getSelection();
		List result= new ArrayList(selection.length);
		List treePaths= new ArrayList();
		for (int i= 0; i < selection.length; i++) {
			TreeItem item= selection[i];
			Object element= getElement(item);
			if (element == null)
				continue;
			if (!result.contains(element)) {
				result.add(element);
			}
			treePaths.add(createTreePath(item));
		}
		return new MultiElementSelection(this, result, (TreePath[])treePaths.toArray(new TreePath[treePaths.size()]));
	}
	private TreePath createTreePath(TreeItem item) {
		List result= new ArrayList();
		result.add(item.getData());
		TreeItem parent= item.getParentItem();
		while (parent != null) {
			result.add(parent.getData());
			parent= parent.getParentItem();
		}
		Collections.reverse(result);
		return new TreePath(result.toArray());
	}
	private Object getElement(TreeItem item) {
		Object result= item.getData();
		if (result == null)
			return null;
		return result;
	}
	protected Widget internalGetWidgetToSelect(Object element) {
		Widget result= findItem(element);
		if (!(result instanceof TreeItem))
			return result;
		if (isInHistroyWorkingSet((TreeItem)result)) {
			List l= (List)getAdditionalMappings().get(element);
			if (l != null && !l.isEmpty()) {
				return (Widget)l.get(0);
			} else {
				// this force to read the parent of the item which will not return
				// the history working set. See corresponding content provider.
				return null;
			}
		}
		return result;
	}
	private boolean isInHistroyWorkingSet(TreeItem item) {
		TreeItem parent= item.getParentItem();
		while (parent != null) {
			Object data= getElement(parent);
			if (data instanceof IWorkingSet && HistoryWorkingSetUpdater.ID.equals(((IWorkingSet)data).getId()))
				return true;
			parent= parent.getParentItem();
		}
		return false;
	}
    protected boolean isSameSelection(List items, Item[] current) {
    	if (items.size() != current.length)
    		return false;
    	Set newSelection= new HashSet(items);
    	for (int i= 0; i < current.length; i++) {
			if (!newSelection.contains(current[i]))
				return false;
		}
    	return true;
    }
    //---- special handling to preserve the selection correctly
    private boolean fInPreserveSelection;
	protected void preservingSelection(Runnable updateCode) {
		try {
			fInPreserveSelection= true;
			super.preservingSelection(updateCode);
		} finally {
			fInPreserveSelection= false;
		}
	}
	protected void setSelectionToWidget(ISelection selection, boolean reveal) {
		// Ensure we don't try and set a selection to a widget being disposed
		if (selection instanceof IStructuredSelection) {
			List selectedElements = ((IStructuredSelection)selection).toList();
			for (int i=0; i<selectedElements.size(); i++) {
				if (fItemsBeingRemoved.contains(selectedElements.get(i)))
					return;
			}
		}
		if (!fInPreserveSelection || !(selection instanceof MultiElementSelection)) {
			super.setSelectionToWidget(selection, reveal);
			return;
		}
		IContentProvider cp= getContentProvider();
		if (!(cp instanceof IMultiElementTreeContentProvider)) {
			super.setSelectionToWidget(selection, reveal);
			return;
		}
		IMultiElementTreeContentProvider contentProvider= (IMultiElementTreeContentProvider)cp;
		MultiElementSelection toRestore= (MultiElementSelection)selection;
		List pathsToSelect= new ArrayList();
		for (Iterator iter= toRestore.iterator(); iter.hasNext();) {
			Object element= iter.next();
			TreePath[] pathsToRestore= toRestore.getTreePaths(element);
			CustomHashtable currentParents= createRootAccessedMap(contentProvider.getTreePaths(element));
			for (int i= 0; i < pathsToRestore.length; i++) {
				TreePath path= pathsToRestore[i];
				Object root= path.getFirstSegment();
				if (root != null && path.equals((TreePath)currentParents.get(root), getComparer())) {
					pathsToSelect.add(path);
				}
			}
		}
		List toSelect= new ArrayList();
		for (Iterator iter= pathsToSelect.iterator(); iter.hasNext();) {
			TreePath path= (TreePath)iter.next();
			int size= path.getSegmentCount();
			if (size == 0)
				continue;
			Widget current= getTree();
			int last= size - 1;
			Object segment;
			for (int i= 0; i < size && current != null && (segment= path.getSegment(i)) != null; i++) {
				internalExpandToLevel(current, 1);
				current= internalFindChild(current, segment);
				if (i == last && current != null)
					toSelect.add(current);
			}
		}
		getTree().setSelection((TreeItem[])toSelect.toArray(new TreeItem[toSelect.size()]));
	}
    private Widget internalFindChild(Widget parent, Object element) {
        Item[] items = getChildren(parent);
        for (int i = 0; i < items.length; i++) {
            Item item = items[i];
            Object data = item.getData();
            if (data != null && equals(data, element))
                return item;
        }
        return null;
    }
	private CustomHashtable createRootAccessedMap(TreePath[] paths) {
		CustomHashtable result= new CustomHashtable(getComparer());
		for (int i= 0; i < paths.length; i++) {
			TreePath path= paths[i];
			Object root= path.getFirstSegment();
			if (root != null) {
				result.put(root, path);
			}
		}
		return result;
	}


}
