/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.groups;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class NavigatorGroupActionProvider extends CommonActionProvider implements ICommonActionProvider {
	
	static final String NAVIGATOR_GROUP_CONTENT_EXTENSION = "org.eclipse.wst.common.navigator.internal.plugin.root"; //$NON-NLS-1$

	private static final String GROUPING_ENABLED = "GROUPING_ENABLED"; //$NON-NLS-1$

	private ToggleGroupingAction toggleGroupingAction;
	private boolean hasAddedAction;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#init(org.eclipse.ui.IViewPart,
	 *      org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
		toggleGroupingAction = new ToggleGroupingAction(aViewer, aContentService);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#dispose()
	 */
	public void dispose() {
		//dispose
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#setActionContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setActionContext(ActionContext aContext) {
		//do nothing
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public boolean fillContextMenu(IMenuManager aMenu) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public boolean fillActionBars(IActionBars theActionBars) {

		if (!hasAddedAction) {
			theActionBars.getMenuManager().add(toggleGroupingAction);
			theActionBars.getToolBarManager().add(toggleGroupingAction);
			hasAddedAction = true;
			return true;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider#restoreState(org.eclipse.ui.IMemento)
	 */
	public void restoreState(IMemento aMemento) {
		if (aMemento != null) {
			super.restoreState(aMemento);
			Integer isGroupingEnabledValue = aMemento.getInteger(GROUPING_ENABLED);
			toggleGroupingAction.setGroupingEnabled((isGroupingEnabledValue != null) ? isGroupingEnabledValue.intValue() == 1 : true);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider#saveState(org.eclipse.ui.IMemento)
	 */
	public void saveState(IMemento aMemento) {
		if (aMemento != null) {
			super.saveState(aMemento);
			aMemento.putInteger(GROUPING_ENABLED, toggleGroupingAction.isGroupingEnabled() ? 1 : 0);
		}
	}

}
