/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Mar 17, 2004
 * 
 * To change the template for this generated file go to Window - Preferences - Java - Code Generation - Code and
 * Comments
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;


/**
 * @author jsholl
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class NavigatorGroupActivityHelper {
	public static List navigatorGroups;

	public static List getEnabledGroups() {
		if (null == navigatorGroups) {
			navigatorGroups = NavigatorGroupExtensionReader.getInstance().getNonExcludedGroupsList();
		}
		IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
		IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
		Set enabledActivityIDs = activityManager.getEnabledActivityIds();
		ArrayList enabledGroups = new ArrayList();
		NavigatorGroup group = null;
		for (int i = 0; i < navigatorGroups.size(); i++) {
			group = (NavigatorGroup) navigatorGroups.get(i);
			IIdentifier identifier = activityManager.getIdentifier(WorkbenchActivityHelper.createUnifiedId(group.getContribution()));
			Set idActivities = identifier.getActivityIds();
			if (idActivities.size() == 0) {
				enabledGroups.add(group);
			} else {
				Iterator iterator = idActivities.iterator();
				boolean added = false;
				while (!added && iterator.hasNext()) {
					if (enabledActivityIDs.contains(iterator.next())) {
						added = true;
						enabledGroups.add(group);
					}
				}
			}
		}
		return enabledGroups;
	}
}