/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Feb 3, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonOpenListener;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;

/**
 * @author Admin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JavaResourceOpenListener implements ICommonOpenListener{

	private CommonNavigator commonNavigator;
	private NavigatorContentService contentService;
	OpenAction openAction ;

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IOpenListener#open(org.eclipse.jface.viewers.OpenEvent)
	 */
	public void open(OpenEvent event) {
		ISelection selection = event.getSelection();
		if (selection != null && selection instanceof IStructuredSelection) {
			if (openAction != null ) {
				IStructuredSelection structureSelection = (IStructuredSelection) selection;
				openAction.selectionChanged(structureSelection);
				if (openAction.isEnabled())
		            openAction.run();
			}
		}
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.navigator.internal.views.extensions.ICommonOpenListener#initialize(org.eclipse.wst.common.navigator.views.CommonNavigator, org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void initialize(CommonNavigator aCommonNavigator, NavigatorContentService aContentService) {
		commonNavigator = aCommonNavigator;
		contentService = aContentService;
		openAction= new OpenAction(aCommonNavigator.getSite());
	}

}
