/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.IResourceActionFilter;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * Representation of class path containers in Java UI.
 * 
 * Copied from JDT UI plugin because PkgExplorerContentProvider uses package visible contains
 * method.
 */
public class ClassPathContainer extends org.eclipse.jdt.internal.ui.packageview.ClassPathContainer {


	public ClassPathContainer(IJavaProject parent, IClasspathEntry entry) {
		super(parent, entry);
	}

	public Object getAdapter(Class adapter) {
		if (adapter == IWorkbenchAdapter.class)
			return this;
		return super.getAdapter(adapter);
	}

	/**
	 * Returns whether the specific attribute matches the state of the target object.
	 * 
	 * @param target
	 *            the target object
	 * @param name
	 *            the attribute name
	 * @param value
	 *            the attribute value
	 * @return <code>true</code> if the attribute matches; <code>false</code> otherwise
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if (!(target instanceof ClassPathContainer)) {
			return false;
		}
		if (name.equals(IResourceActionFilter.PROJECT_NATURE)) {
			IJavaProject javaProject = getJavaProject();
			IProject project = javaProject.getProject();
			try {
				return project.isAccessible() && project.hasNature(value);
			} catch (CoreException e) {
				return false;
			}
		}
		return false;
	}
}
