/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.filters.NavigatorExtensionFilter;

public class ClosedProjectFilter extends NavigatorExtensionFilter {

	public ClosedProjectFilter() {
		super();
	}

	public boolean select(CommonViewer aViewer, Object aParentElement, Object anElement) {
		if (anElement instanceof IJavaElement) 
			return ((IJavaElement)anElement).getJavaProject().getProject().isOpen();
		if (anElement instanceof IResource)
			return ((IResource)anElement).getProject().isOpen();
		return true;
	}

}
