/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Jan 22, 2005
 * 
 * TODO To change the template for this generated file go to Window - Preferences - Java - Code
 * Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.java;

import java.util.Comparator;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;


final class JavaElementComparator implements Comparator {
	private final ILabelProvider labelProvider;

	/**
	 * @param extension
	 */
	JavaElementComparator(ILabelProvider aLabelProvider) {
		labelProvider = aLabelProvider;
	}

	ContentViewer cv = new ContentViewer() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ContentViewer#getLabelProvider()
		 */
		public IBaseLabelProvider getLabelProvider() {
			return labelProvider;
		}

		public Control getControl() {
			return null;
		}

		public ISelection getSelection() {
			return null;
		}

		public void refresh() {
		}

		public void setSelection(ISelection selection, boolean reveal) {
		}
	};

	JavaElementSorter sorter = new JavaElementSorter();

	public int compare(Object o1, Object o2) {
		if (o1 instanceof IJavaElement && o2 instanceof IJavaElement)
			return sorter.compare(cv, o1, o2);
		return -1;
	}

	public boolean equals(Object obj) {
		return false;
	}
}