/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.ui.properties.internal.provisional;

import org.eclipse.jface.viewers.IStructuredContentProvider;

/**
 * An implementation of the content provider for the tabbed property sheet
 * page's list of tabs. This implementation dynamically overrides what tabs are
 * displayed, rather than using the default list of tabs is read from the
 * PropertyTab extension point.
 * 
 * @author Anthony Hunter <a
 *         href="mailto:anthonyh@ca.ibm.com">anthonyh@ca.ibm.com </a>
 */
public interface IDynamicTabListContentProvider
	extends IStructuredContentProvider {

	/**
	 * Dynamically override the tabs displayed in the tab list.
	 */
	public void overrideTabs();
}
