/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.text.MessageFormat;
import java.util.Iterator;

import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;

public class GlobalSimpleOrComplexTypeCleanup extends BaseGlobalCleanup
{
  /**
   * Constructor for GlobalSimpleOrComplexTypeCleanup.
   * @param deletedItem
   */
  public GlobalSimpleOrComplexTypeCleanup(XSDConcreteComponent deletedItem)
  {
    super(deletedItem);
  }

  /**
   * @see org.eclipse.wst.xsd.ui.internal.refactor.XSDVisitor#visitElementDeclaration(XSDElementDeclaration)
   */
  public void visitElementDeclaration(XSDElementDeclaration element)
  {
    if (!element.isElementDeclarationReference() &&
        deletedItem.equals(element.getTypeDefinition()))
    {
      resetTypeToString(element.getElement());
      
      String msg = "";
      if (element.isGlobal())
      {
        String pattern = XSDEditorPlugin.getXSDString("_INFO_RESET_GLOBAL_ELEMENT");
        Object args[] = {element.getName()};
        msg = MessageFormat.format(pattern, args);
      }
      else
      {
        msg = XSDEditorPlugin.getXSDString("_INFO_RESET_ELEMENT");
        msg += "<" + element.getName() + "> " + XSDEditorPlugin.getXSDString("_UI_TO_TYPE_STRING");
      }
      addMessage(msg, element);
    }


    super.visitElementDeclaration(element);
  }

  /**
   * @see org.eclipse.wst.xsd.ui.internal.refactor.XSDVisitor#visitComplexTypeDefinition(XSDComplexTypeDefinition)
   */
  public void visitComplexTypeDefinition(XSDComplexTypeDefinition type)
  {
    super.visitComplexTypeDefinition(type);
    if (type.getAttributeContents() != null)
    {
      for (Iterator iter = type.getAttributeContents().iterator(); iter.hasNext(); )
      {
        XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent) iter.next();
        if (attrGroupContent instanceof XSDAttributeUse)
        {
          XSDAttributeUse attrUse = (XSDAttributeUse) attrGroupContent;
          XSDAttributeDeclaration attrDecl = attrUse.getContent();
          
          // now is this a reference?
          if (attrDecl != null &&
              !attrDecl.isAttributeDeclarationReference() &&
              deletedItem.equals(attrDecl.getTypeDefinition()))
          {
              resetTypeToString(attrDecl.getElement());
              // reset the type of the attribute decl to string
              String msg = XSDEditorPlugin.getXSDString("_INFO_RESET_ATTRIBUTE") +
                          " <" + attrDecl.getName() + "> " +
                          XSDEditorPlugin.getXSDString("_UI_TO_TYPE_STRING");
              addMessage(msg, attrDecl);
              resetTypeToString(attrDecl.getElement());
          }
        }
      }
    }
    XSDTypeDefinition base = type.getBaseTypeDefinition();
    if (base != null && base == deletedItem)
    {
      String msg = XSDEditorPlugin.getXSDString("_INFO_RESET_COMPLEX_TYPE") +
              " <" + getNamedComponentName(type) + "> " +
              XSDEditorPlugin.getXSDString("_UI_DERIVATION");

      addMessage(msg, type);
      
      type.setBaseTypeDefinition(null);

      java.util.List listOfCT = schema.getTypeDefinitions();
      XSDTypeDefinition typeDefinition = null;
      if (listOfCT.size() > 0)
      {
        for (Iterator iter = listOfCT.iterator(); iter.hasNext(); )
        {
          typeDefinition = (XSDTypeDefinition)iter.next();
          if (typeDefinition != deletedItem)
          {
            type.setBaseTypeDefinition(typeDefinition);
          }
        }
      }
    }
  }

  public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition type)
  {
    if (type.getBaseTypeDefinition() == deletedItem)
    {
      type.setBaseTypeDefinition(schema.resolveSimpleTypeDefinition(XSDConstants.SCHEMA_FOR_SCHEMA_URI_2001, "string"));
    }
  }

  protected void resetTypeToString(Element element)
  {
    String prefix = element.getPrefix();
    prefix = (prefix == null) ? "" : (prefix + ":");
    
    element.setAttribute(XSDConstants.TYPE_ATTRIBUTE, prefix + "string"); 
  }
  
}
