/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs;

/**
 * @author groux
 */
public abstract class AbstractDerbyUrl
{
    protected String subprotocol = ""; //$NON-NLS-1$
    protected String node = ""; //$NON-NLS-1$
    protected String port = ""; //$NON-NLS-1$
    protected String databaseName = ""; //$NON-NLS-1$
    protected String properties = ""; //$NON-NLS-1$

    /**
     * @param url
     */
    public AbstractDerbyUrl(String url) {
        parseURL(url);
    }

    /**
     * @return Returns the databaseName.
     */
    public String getDatabaseName() {
        return databaseName;
    }

    /**
     * @return Returns the node.
     */
    public String getNode() {
        return node;
    }

    /**
     * @return Returns the subprotocol.
     */
    public String getSubprotocol() {
        return subprotocol;
    }

    protected abstract void parseURL(String url);

    /**
     * @return Returns the port.
     */
    public String getPort() {
        return port;
    }

    /**
     * @return Returns the properties.
     */
    public String getProperties() {
        return properties;
    }
}
