/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs;


/**
 * @author ljulien
 */
public class DerbyClientNewConnectionProvider extends AbstractDerbyConnectionProvider
{

    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.ClientDriver"; //$NON-NLS-1$

	protected String getDriverClassName()
	{
		return DRIVER_CLASS_NAME;
	}


    protected void updateURL() {
        String url = "jdbc:derby://" + hostCombo.getText() + ":" //$NON-NLS-1$ //$NON-NLS-2$
                + portCombo.getText() + "/" //$NON-NLS-1$
                + encodeDatabaseName(databaseCombo.getText());
        urlDisplay.setText(url);
        connectionInformation.setURL(url);
    }

    protected String encodeDatabaseName(String name)
    {
        String processedName = name;
        processedName += !createCheck.getSelection() ? "" //$NON-NLS-1$
                : (";" + CREATE_EQUALS_TRUE_TEXT); //$NON-NLS-1$
        if (displayUpgrade)
            processedName += !upgradeCheck.getSelection() ? "" //$NON-NLS-1$
                : (";" + UPGRADE_EQUALS_TRUE_TEXT); //$NON-NLS-1$

        return processedName;
    }
    
    protected String decodeDatabaseName(String name)
    {
        String processedName = name;
        if (name.indexOf('"') > -1) {	
            String remainingName = name.substring(name.indexOf('"') + 1);
            processedName = remainingName.substring(0, remainingName.indexOf('"'));
        } else {
            if (name.indexOf(';') > -1) {
                processedName = name.substring(0, name.indexOf(';'));
            }
        }
        return processedName;
    }


    public void loadProperties() {
        removeListeners();
        String rawURL = connectionInformation.getURL();
		
        if (!(rawURL.indexOf(CREATE_EQUALS_TRUE_TEXT) > -1)) {
			createCheck.setSelection(false);
		} else {
		    rawURL = rawURL.replaceFirst(";" + CREATE_EQUALS_TRUE_TEXT, ""); //$NON-NLS-1$ //$NON-NLS-2$
		    createCheck.setSelection(true);
		}
        
        if (displayUpgrade)
	        if (!(rawURL.indexOf(UPGRADE_EQUALS_TRUE_TEXT) > -1)) {
				upgradeCheck.setSelection(false);
			} else {
			    rawURL = rawURL.replaceFirst(";" + UPGRADE_EQUALS_TRUE_TEXT, ""); //$NON-NLS-1$ //$NON-NLS-2$
			    upgradeCheck.setSelection(true);
			}

        DerbyClientJDBCURL url = new DerbyClientJDBCURL(
                rawURL);
        locationCombo.setText(connectionInformation.getLoadingPath());
        hostCombo.setText(url.getNode());
        portCombo.setText(url.getPort());
        databaseCombo.setText(url.getDatabaseName());
        updateURL();
        addListeners();
        setConnectionInformation();
    }

    private class DerbyClientJDBCURL extends AbstractDerbyUrl {

        public DerbyClientJDBCURL(String url) {
            super(url);
        }

        protected void parseURL(String url)
        {
            try {
                String remainingURL = url.substring(url.indexOf(':') + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(':'));
                remainingURL = remainingURL.substring(remainingURL.indexOf(':') + 1);
                remainingURL = remainingURL.substring(2);
                this.node = remainingURL.substring(0, remainingURL.indexOf('/'));

                if (this.node.indexOf(':') > -1) {
                    this.port = this.node.substring(this.node.indexOf(':') + 1);
                    this.node = this.node.substring(0, this.node.indexOf(':'));
                }
                remainingURL = remainingURL.substring(remainingURL.indexOf('/') + 1);
                this.databaseName = decodeDatabaseName(remainingURL);
            } catch (Exception e) {
            }
        }
    }
}
