/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.dialogfield;

import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StringDialogField
extends DialogFieldBase
implements ISupportTextValue {
    private static final int TEXT_WIDTH_HINT = 10;
    private String text = "";
    private Text textControl;
    private ModifyListener modifyListener;
    private int numRows = 1;
    private boolean pending = false;

    public StringDialogField() {
    }

    public StringDialogField(int numRows) {
        this.numRows = numRows;
    }

    public Control[] doFillIntoGrid(FormToolkit kit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(kit, parent);
        requiredLabel.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(kit, parent);
        label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(kit, parent);
        int heightHint = -1;
        if (this.numRows > 1) {
            heightHint = this.getDialogUnits((Control)parent).getHeight() * this.numRows;
        }
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 2, heightHint));
        return new Control[]{requiredLabel, label, text};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    protected static GridData gridDataForText(int span, int heightHint) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.heightHint = heightHint;
        gd.horizontalSpan = span;
        gd.widthHint = 10;
        return gd;
    }

    protected static GridData gridDataForText(int span) {
        GridData gd = StringDialogField.gridDataForText(span, -1);
        return gd;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.textControl)) {
            this.textControl.setFocus();
            this.textControl.setSelection(0, this.textControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(FormToolkit toolkit, Composite parent) {
        if (this.textControl == null) {
            this.assertCompositeNotNull(parent);
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringDialogField.this.doModifyText(e);
                }
            };
            this.textControl = toolkit != null ? (this.numRows <= 1 ? toolkit.createText(parent, "") : toolkit.createText(parent, "", 512)) : (this.numRows <= 1 ? new Text(parent, 2052) : new Text(parent, 2624));
            this.textControl.setText(this.text);
            this.textControl.setFont(parent.getFont());
            this.textControl.addModifyListener(this.modifyListener);
            this.textControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    StringDialogField.this.doFocusLost(e);
                }
            });
            this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    StringDialogField.this.doKeyReleased(e);
                }
            });
            this.textControl.setEnabled(this.isEnabled());
        }
        return this.textControl;
    }

    protected void doKeyReleased(KeyEvent e) {
        if (this.textControl.isDisposed()) {
            return;
        }
        if (e.character == '\r' && this.numRows <= 1 && this.pending) {
            this.pending = false;
            this.dialogFieldApplied();
        }
    }

    protected void doFocusLost(FocusEvent e) {
        if (this.pending) {
            this.pending = false;
            this.dialogFieldApplied();
        }
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.textControl)) {
            this.text = this.textControl.getText();
        }
        this.pending = true;
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.textControl)) {
            this.textControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.setTextWithoutUpdate(text);
        this.dialogFieldChangedAndApplied();
    }

    public void setTextWithoutUpdate(String text) {
        this.pending = false;
        if (text == null) {
            text = "";
        }
        if (this.isOkToUse((Control)this.textControl)) {
            this.textControl.removeModifyListener(this.modifyListener);
            this.textControl.setText(text);
            this.textControl.addModifyListener(this.modifyListener);
        }
        this.text = text;
    }

    public void handleGrabHorizontal() {
        LayoutUtil.setGrabHorizontal((Control)this.textControl, true);
    }
}

