/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigModelAdapter;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryWizard;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.IJSFImplLibraryCreationListener;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.JSFImplLibraryCreationEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class JSFLibraryConfigControl
extends Composite {
    private final int COLUMN_DEPLOY = 0;
    private final int COLUMN_LIB_NAME = 1;
    private JSFLibraryConfigModelAdapter provider = null;
    private ComboViewer cvImplLib;
    private CheckboxTableViewer ctvSelCompLib;
    private Button btnDeployJars;
    private TreeViewer tvCompLib;
    private TreeViewerAdapter tvAdapter;
    private TreeLabelProvider tvLabelProvider;
    private Combo comboImplLib;
    private Vector newJSFLibCreatedListeners = new Vector();

    public void addOkClickedListener(IJSFImplLibraryCreationListener listener) {
        this.newJSFLibCreatedListeners.addElement(listener);
    }

    public void removeOkClickedListener(IJSFImplLibraryCreationListener listener) {
        this.newJSFLibCreatedListeners.removeElement(listener);
    }

    public JSFLibraryConfigControl(Composite parent, int style, IProject fProject) {
        super(parent, style);
        this.provider = new JSFLibraryConfigModelAdapter(fProject);
        this.initControls();
    }

    public JSFLibraryConfigModelAdapter getModelProvider() {
        return this.provider;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public JSFLibraryDecorator getSelectedJSFLibImplementation() {
        return this.provider.getSelectedJSFImplLibrary();
    }

    public List getSelectedJSFLibComponents() {
        return this.provider.getSelectedJSFCompLibraries();
    }

    private void initializeControlValues() {
        this.loadJSFImplList();
        this.btnDeployJars.setSelection(false);
        if (this.provider.getSavedJSFImplementationLibrary() != null) {
            JSFLibraryDecorator selJSFImplLib = this.provider.getSavedJSFImplementationLibrary();
            this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)selJSFImplLib), true);
            this.btnDeployJars.setSelection(selJSFImplLib.isCheckedToBeDeployed());
        } else {
            JSFLibraryDecorator dftJSFImplLib = this.provider.getDefaultJSFImplemntationLibrary();
            if (dftJSFImplLib != null) {
                this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)dftJSFImplLib), true);
                this.btnDeployJars.setSelection(dftJSFImplLib.isCheckedToBeDeployed());
            }
        }
        this.loadJSFCompList();
        JSFLibraryDecorator jsfLibDctr = null;
        List jsfCompLibs = this.provider.getSavedJSFComponentLibraries();
        int i = 0;
        while (i < jsfCompLibs.size()) {
            jsfLibDctr = (JSFLibraryDecorator)jsfCompLibs.get(i);
            this.ctvSelCompLib.setChecked((Object)jsfLibDctr, jsfLibDctr.isCheckedToBeDeployed());
            ++i;
        }
        this.redraw();
    }

    private void loadJSFImplList() {
        this.cvImplLib.setInput((Object)this.provider.getJSFImplementationLibraries());
    }

    private void loadJSFCompList() {
        this.tvCompLib.setInput((Object)this.provider.getJSFComponentLibraries());
        this.ctvSelCompLib.setInput((Object)this.provider.getJSFComponentLibraries());
    }

    private JSFLibraryDecorator getJSFImplLibwUpdatedState() {
        JSFLibraryDecorator selJSFImpl = null;
        StructuredSelection objs = (StructuredSelection)this.cvImplLib.getSelection();
        if (objs != null && objs.getFirstElement() instanceof JSFLibraryDecorator) {
            selJSFImpl = (JSFLibraryDecorator)objs.getFirstElement();
            selJSFImpl.setToBeDeployed(this.btnDeployJars.getSelection());
        }
        return selJSFImpl;
    }

    private void initControls() {
        this.setRedraw(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Label lblImplLib = new Label((Composite)this, 0);
        GridData gd_lbl_impl = new GridData(1, 2, false, false, 2, 1);
        lblImplLib.setLayoutData((Object)gd_lbl_impl);
        lblImplLib.setText(Messages.JSFLibraryConfigControl_ImplementationLibrary);
        this.btnDeployJars = new Button((Composite)this, 32);
        this.btnDeployJars.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        this.btnDeployJars.setText(Messages.JSFLibraryConfigControl_DeployJAR);
        this.btnDeployJars.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryDecorator jsflib = JSFLibraryConfigControl.this.getJSFImplLibwUpdatedState();
                JSFLibraryConfigControl.this.provider.updateJSFImplementationLibrary(jsflib);
            }
        });
        Composite compTest = new Composite((Composite)this, 0);
        GridLayout compgl = new GridLayout();
        compgl.numColumns = 2;
        compgl.marginLeft = 0;
        compgl.marginRight = 0;
        compgl.marginWidth = 0;
        GridData gdCompTest = new GridData(4, 4, true, false);
        gdCompTest.horizontalSpan = 4;
        compTest.setLayoutData((Object)gdCompTest);
        compTest.setLayout((Layout)compgl);
        this.cvImplLib = new ComboViewer(compTest, 8);
        this.cvImplLib.setLabelProvider((IBaseLabelProvider)new ImplLibCVListLabelProvider());
        this.cvImplLib.setContentProvider((IContentProvider)new ImplLibCVContentProvider());
        this.comboImplLib = this.cvImplLib.getCombo();
        GridData gd_cvImplLib = new GridData(4, 2, true, false, 1, 1);
        this.comboImplLib.setLayoutData((Object)gd_cvImplLib);
        this.cvImplLib.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                JSFLibraryConfigControl.this.provider.updateJSFImplementationLibrary((JSFLibraryDecorator)ss.getFirstElement());
            }
        });
        Button btnNewImpl = new Button(compTest, 0);
        btnNewImpl.setLayoutData((Object)new GridData(2, 2, false, false));
        btnNewImpl.setText(Messages.JSFLibraryConfigControl_NewImplementationLibrary);
        btnNewImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryWizard wizard = new JSFLibraryWizard(true);
                IWorkbench wb = PlatformUI.getWorkbench();
                wizard.init(wb, null);
                WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int ret = dialog.open();
                if (ret == 0) {
                    JSFLibraryDecorator jsfLibDctr = new JSFLibraryDecorator(wizard.getJSFLibrary(), true, true);
                    JSFLibraryRegistry jsflibreg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
                    jsflibreg.addJSFLibrary(wizard.getJSFLibrary());
                    JSFLibraryConfigControl.this.provider.addJSFLibrary(jsfLibDctr);
                    JSFLibraryConfigControl.this.provider.updateJSFImplementationLibrary(jsfLibDctr);
                    JSFLibraryConfigControl.this.loadJSFImplList();
                    JSFLibraryConfigControl.this.btnDeployJars.setSelection(true);
                    JSFLibraryConfigControl.this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)jsfLibDctr), true);
                }
                JSFImplLibraryCreationEvent event = new JSFImplLibraryCreationEvent((Object)this, ret == 0);
                int size = JSFLibraryConfigControl.this.newJSFLibCreatedListeners.size();
                int i = 0;
                while (i < size) {
                    IJSFImplLibraryCreationListener listener = (IJSFImplLibraryCreationListener)JSFLibraryConfigControl.this.newJSFLibCreatedListeners.elementAt(i);
                    listener.okClicked(event);
                    ++i;
                }
            }
        });
        Label lblSeparator = new Label((Composite)this, 258);
        GridData gd_lbl_spacer = new GridData(4, 2, true, false, 4, 1);
        lblSeparator.setLayoutData((Object)gd_lbl_spacer);
        lblSeparator.setAlignment(0x1000000);
        Label lblCompLib = new Label((Composite)this, 0);
        GridData gd_lbl_complib = new GridData(4, 2, false, false, 4, 1);
        lblCompLib.setLayoutData((Object)gd_lbl_complib);
        lblCompLib.setText(Messages.JSFLibraryConfigControl_ComponentLibrary);
        this.tvCompLib = new TreeViewer((Composite)this, 2816);
        this.tvAdapter = new TreeViewerAdapter();
        this.tvLabelProvider = new TreeLabelProvider();
        this.tvCompLib.setContentProvider((IContentProvider)this.tvAdapter);
        this.tvCompLib.setLabelProvider((IBaseLabelProvider)this.tvLabelProvider);
        this.tvCompLib.addSelectionChangedListener((ISelectionChangedListener)this.tvAdapter);
        this.tvCompLib.addDoubleClickListener((IDoubleClickListener)this.tvAdapter);
        this.tvCompLib.getTree().setLayoutData((Object)new GridData(1808));
        this.tvCompLib.addFilter((ViewerFilter)new TreeViewerFilter());
        Composite composite_buttons = new Composite((Composite)this, 0);
        composite_buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        composite_buttons.setLayout((Layout)new GridLayout());
        Composite composite_Single = new Composite(composite_buttons, 0);
        composite_Single.setLayoutData((Object)new GridData(768));
        GridLayout gl_Single = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_Single.setLayout((Layout)gl_Single);
        Button btnAdd = new Button(composite_Single, 0);
        btnAdd.setLayoutData((Object)new GridData(4, 2, true, false));
        btnAdd.setText(Messages.JSFLibraryConfigControl_Add);
        Button btnRemove = new Button(composite_Single, 0);
        btnRemove.setLayoutData((Object)new GridData(4, 2, true, false));
        btnRemove.setText(Messages.JSFLibraryConfigControl_Remove);
        Composite composite_All = new Composite(composite_buttons, 0);
        composite_All.setLayoutData((Object)new GridData(768));
        GridLayout gl_All = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_All.setLayout((Layout)gl_All);
        Button btnAddAll = new Button(composite_All, 0);
        btnAddAll.setLayoutData((Object)new GridData(4, 2, true, false));
        btnAddAll.setText(Messages.JSFLibraryConfigControl_AddAll);
        Button btnRemoveAll = new Button(composite_All, 0);
        btnRemoveAll.setLayoutData((Object)new GridData(4, 2, true, false));
        btnRemoveAll.setText(Messages.JSFLibraryConfigControl_RemoveAll);
        Composite composite_New = new Composite(composite_buttons, 0);
        composite_New.setLayoutData((Object)new GridData(768));
        GridLayout gl_New = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_New.setLayout((Layout)gl_New);
        Button btnNewCompLib = new Button(composite_New, 0);
        btnNewCompLib.setLayoutData((Object)new GridData(4, 2, false, false));
        btnNewCompLib.setText(Messages.JSFLibraryConfigControl_NewComponentLibrary);
        btnNewCompLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryWizard wizard = new JSFLibraryWizard(false);
                IWorkbench wb = PlatformUI.getWorkbench();
                wizard.init(wb, null, true);
                WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int ret = dialog.open();
                if (ret == 0) {
                    JSFLibrary newCompLib = wizard.getJSFLibrary();
                    JSFLibraryDecorator jsfLibDctr = new JSFLibraryDecorator(newCompLib, true, true);
                    JSFLibraryRegistry jsflibreg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
                    jsflibreg.addJSFLibrary(newCompLib);
                    JSFLibraryConfigControl.this.provider.addJSFLibrary(jsfLibDctr);
                    JSFLibraryConfigControl.this.loadJSFCompList();
                    JSFLibraryConfigControl.this.ctvSelCompLib.setChecked((Object)jsfLibDctr, true);
                }
            }
        });
        this.ctvSelCompLib = CheckboxTableViewer.newCheckList((Composite)this, (int)67586);
        this.ctvSelCompLib.addFilter((ViewerFilter)new CheckedTableViewerFilter());
        Table table = this.ctvSelCompLib.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        TableColumn tcDeploy = new TableColumn(table, 16384);
        tcDeploy.setWidth(50);
        tcDeploy.setText(Messages.JSFLibraryConfigControl_TH_Deploy);
        TableColumn tcLibName = new TableColumn(table, 16384);
        tcLibName.setWidth(150);
        tcLibName.setText(Messages.JSFLibraryConfigControl_TH_LibraryName);
        this.ctvSelCompLib.setSorter((ViewerSorter)new SelectedCompLibCTVSorter());
        this.ctvSelCompLib.setLabelProvider((IBaseLabelProvider)new SelectedCompLibCTVLabelProvider());
        this.ctvSelCompLib.setContentProvider((IContentProvider)new CompLibCTVContentProvider());
        this.ctvSelCompLib.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JSFLibraryDecorator changedItem = (JSFLibraryDecorator)event.getElement();
                boolean isChecked4Deploy = event.getChecked();
                List list = JSFLibraryConfigControl.this.provider.getJSFComponentLibraries();
                Iterator it = list.iterator();
                JSFLibraryDecorator crtjsflib = null;
                while (it.hasNext()) {
                    crtjsflib = (JSFLibraryDecorator)it.next();
                    if (!crtjsflib.getID().equals(changedItem.getID())) continue;
                    crtjsflib.setToBeDeployed(isChecked4Deploy);
                    break;
                }
            }
        });
        btnAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JSFLibraryConfigControl.this.resetComponentLibSelection((StructuredSelection)JSFLibraryConfigControl.this.tvCompLib.getSelection(), JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, true);
            }
        });
        btnAddAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JSFLibraryConfigControl.this.resetCompontLibSelectionAll(JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, true);
            }
        });
        btnRemove.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JSFLibraryConfigControl.this.resetComponentLibSelection((StructuredSelection)JSFLibraryConfigControl.this.ctvSelCompLib.getSelection(), JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, false);
            }
        });
        btnRemoveAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JSFLibraryConfigControl.this.resetCompontLibSelectionAll(JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, false);
            }
        });
        this.initializeControlValues();
    }

    private void resetComponentLibSelection(StructuredSelection item, TreeViewer srcViewer, CheckboxTableViewer destViewer, boolean state) {
        if (item != null && item.getFirstElement() != null) {
            JSFLibraryDecorator jsfLibDctr = (JSFLibraryDecorator)item.getFirstElement();
            List list = this.provider.getJSFComponentLibraries();
            Iterator it = list.iterator();
            JSFLibraryDecorator crtjsfLibDctr = null;
            while (it.hasNext()) {
                crtjsfLibDctr = (JSFLibraryDecorator)it.next();
                if (!crtjsfLibDctr.getID().equals(jsfLibDctr.getID())) continue;
                crtjsfLibDctr.setToBeDeployed(state);
                crtjsfLibDctr.setSelected(state);
            }
            this.loadJSFCompList();
            srcViewer.refresh();
            destViewer.refresh();
            destViewer.setChecked((Object)jsfLibDctr, state);
        }
    }

    private void resetCompontLibSelectionAll(TreeViewer srcViewer, CheckboxTableViewer destViewer, boolean state) {
        List list = this.provider.getJSFComponentLibraries();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            JSFLibraryDecorator jsfLibDctr = (JSFLibraryDecorator)it.next();
            jsfLibDctr.setSelected(state);
            jsfLibDctr.setToBeDeployed(state);
        }
        this.loadJSFCompList();
        srcViewer.refresh();
        destViewer.refresh();
        destViewer.setAllChecked(state);
    }

    class CheckedTableViewerFilter
    extends ViewerFilter {
        CheckedTableViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof JSFLibraryDecorator) {
                return ((JSFLibraryDecorator)element).isSelected();
            }
            return false;
        }
    }

    class CompLibCTVContentProvider
    implements IStructuredContentProvider {
        private List jsfComplLibs = new ArrayList(Collections.EMPTY_LIST);

        CompLibCTVContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.jsfComplLibs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.jsfComplLibs = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }
    }

    class ImplLibCVContentProvider
    implements IStructuredContentProvider {
        private List jsfImplLibs = new ArrayList(Collections.EMPTY_LIST);

        ImplLibCVContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.jsfImplLibs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.jsfImplLibs = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }
    }

    class ImplLibCVListLabelProvider
    extends LabelProvider {
        private JSFLibrary defaultImpl = null;

        ImplLibCVListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof JSFLibraryDecorator) {
                StringBuffer nameBuf = new StringBuffer(((JSFLibraryDecorator)element).getName());
                if (((JSFLibraryDecorator)element).getLibrary() == this.getDefaultImpl()) {
                    nameBuf.append(" ").append(JSFLibraryRegistry.DEFAULT_IMPL_LABEL);
                }
                return nameBuf.toString();
            }
            return null;
        }

        private JSFLibrary getDefaultImpl() {
            if (this.defaultImpl == null) {
                JSFLibraryRegistry jsflibreg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
                this.defaultImpl = jsflibreg.getDefaultImplementation();
            }
            return this.defaultImpl;
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class SelectedCompLibCTVLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SelectedCompLibCTVLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JSFLibraryDecorator) {
                switch (columnIndex) {
                    case 0: {
                        return " ";
                    }
                    case 1: {
                        return ((JSFLibraryDecorator)element).getName();
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class SelectedCompLibCTVSorter
    extends ViewerSorter {
        SelectedCompLibCTVSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof JSFLibraryDecorator && e2 instanceof JSFLibraryDecorator) {
                JSFLibraryDecorator item1 = (JSFLibraryDecorator)e1;
                JSFLibraryDecorator item2 = (JSFLibraryDecorator)e2;
                return item1.getName().compareToIgnoreCase(item2.getName());
            }
            return 0;
        }
    }

    private class TreeLabelProvider
    implements ILabelProvider {
        Image libImg;
        Image jarImg;

        TreeLabelProvider() {
            if (this.jarImg == null) {
                ImageDescriptor jarImgDesc = JSFUiPlugin.getImageDescriptor("obj16/jar_obj.gif");
                this.jarImg = jarImgDesc.createImage();
            }
            if (this.libImg == null) {
                ImageDescriptor libImgDesc = JSFUiPlugin.getImageDescriptor("obj16/library_obj.gif");
                this.libImg = libImgDesc.createImage();
            }
        }

        public Image getImage(Object element) {
            if (element instanceof JSFLibraryDecorator) {
                return this.libImg;
            }
            return this.jarImg;
        }

        public String getText(Object element) {
            StringBuffer labelBuf = new StringBuffer();
            if (element instanceof JSFLibraryDecorator) {
                JSFLibraryDecorator libWrapper = (JSFLibraryDecorator)element;
                JSFLibrary lib = libWrapper.getLibrary();
                labelBuf.append(lib.getName());
                if (lib.isImplementation()) {
                    labelBuf.append(" [implementation");
                    if (lib == JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation()) {
                        labelBuf.append(" - default");
                    }
                    labelBuf.append("]");
                }
            }
            if (element instanceof ArchiveFile) {
                ArchiveFile jar = (ArchiveFile)element;
                labelBuf.append(jar.getName());
                if (!jar.exists()) {
                    labelBuf.append("[missing]");
                }
                labelBuf.append(" - ").append(((ArchiveFile)element).getSourceLocation());
            }
            return labelBuf.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.libImg != null) {
                this.libImg.dispose();
            }
            if (this.jarImg != null) {
                this.jarImg.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TreeViewerAdapter
    implements ITreeContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return JSFLibraryConfigControl.this.provider.getJSFComponentLibraries().toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof JSFLibraryDecorator) {
                return ((JSFLibraryDecorator)element).getArchiveFiles().toArray();
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof JSFLibraryDecorator;
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }

        public void doubleClick(DoubleClickEvent event) {
        }
    }

    class TreeViewerFilter
    extends ViewerFilter {
        TreeViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof JSFLibraryDecorator) {
                return !((JSFLibraryDecorator)element).isSelected();
            }
            return true;
        }
    }
}

