/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import org.eclipse.jface.preference.IPreferenceStore;

public class ELValidationPreferences {
    private static final String KEY_ENABLE_BUILD_VALIDATION = "org.eclipse.jst.jsf.ui.ValidateJSFELBuild";
    private static final boolean DEFAULT_ENABLE_BUILD_VALIDATION = true;
    private static final String KEY_ENABLE_INCREMENTAL_VALIDATION = "org.eclipse.jst.jsf.ui.ValidateJSFELIncremental";
    private static final boolean DEFAULT_ENABLE_INCREMENTAL_VALIDATION = false;
    private boolean _enableBuildValidation;
    private boolean _enableIncrementalValidation;

    public void load(IPreferenceStore prefStore) {
        if (!prefStore.contains(KEY_ENABLE_BUILD_VALIDATION)) {
            prefStore.setDefault(KEY_ENABLE_BUILD_VALIDATION, true);
        }
        this._enableBuildValidation = prefStore.getBoolean(KEY_ENABLE_BUILD_VALIDATION);
        if (!prefStore.contains(KEY_ENABLE_INCREMENTAL_VALIDATION)) {
            prefStore.setDefault(KEY_ENABLE_INCREMENTAL_VALIDATION, false);
        }
        this._enableIncrementalValidation = prefStore.getBoolean(KEY_ENABLE_INCREMENTAL_VALIDATION);
    }

    public void commit(IPreferenceStore prefStore) {
        prefStore.setValue(KEY_ENABLE_BUILD_VALIDATION, this._enableBuildValidation);
        prefStore.setValue(KEY_ENABLE_INCREMENTAL_VALIDATION, this._enableIncrementalValidation);
    }

    public void setDefaults() {
        this.setEnableBuildValidation(true);
        this.setEnableIncrementalValidation(false);
    }

    public boolean isEnableBuildValidation() {
        return this._enableBuildValidation;
    }

    public boolean isEnableIncrementalValidation() {
        return this._enableIncrementalValidation;
    }

    public void setEnableBuildValidation(boolean enableBuildValidation) {
        this._enableBuildValidation = enableBuildValidation;
    }

    public void setEnableIncrementalValidation(boolean enableIncrementalValidation) {
        this._enableIncrementalValidation = enableIncrementalValidation;
    }
}

