/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.internal.provisional.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ISymbol;
import org.eclipse.jst.jsf.core.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.core.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.core.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.core.internal.types.NullLiteralType;
import org.eclipse.jst.jsf.core.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.core.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.designtime.internal.provisional.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.internal.provisional.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.el.EvaluationTracker;
import org.eclipse.jst.jsf.validation.internal.el.ValueExpressionTracker;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.ValidationMessageFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.BinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.TernaryChoiceOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.UnaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOperatorExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

class ASTSemanticValidator
implements JSPELParserVisitor {
    private final IFile _targetFile;
    private final ASTExpression _expr;
    private final IStructuredDocumentContext _context;
    private final ISymbolContextResolver _symbolResolver;
    private final List _messages;
    private final EvaluationTracker _tracker;

    ASTSemanticValidator(ASTExpression expr, IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        this._targetFile = resolver != null ? (IFile)resolver.getResource() : null;
        this._expr = expr;
        this._context = context;
        this._symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver(this._context);
        this._messages = new ArrayList();
        this._tracker = new EvaluationTracker();
    }

    public void validate() {
        this._expr.jjtAccept((JSPELParserVisitor)this, (Object)this._tracker);
    }

    public Object visit(ASTAddExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTAndExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTChoiceExpression node, Object data) {
        if (node.jjtGetNumChildren() != 3) {
            throw new AssertionError((Object)"Binary operators should always have two sub-expressions");
        }
        node.jjtGetChild(0).jjtAccept((JSPELParserVisitor)this, data);
        ValueType choiceArg = ((EvaluationTracker)data).getValueType();
        node.jjtGetChild(1).jjtAccept((JSPELParserVisitor)this, data);
        ValueType whenTrueArg = ((EvaluationTracker)data).getValueType();
        node.jjtGetChild(2).jjtAccept((JSPELParserVisitor)this, data);
        ValueType whenFalseArg = ((EvaluationTracker)data).getValueType();
        if (choiceArg != null && whenTrueArg != null && whenFalseArg != null) {
            TernaryChoiceOperator operator = new TernaryChoiceOperator();
            Diagnostic diagnostic = operator.validate(choiceArg, whenTrueArg, whenFalseArg);
            if (diagnostic.getSeverity() != 0) {
                Token firstToken = node.getFirstToken();
                int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                Message message = ValidationMessageFactory.createFromDiagnostic(diagnostic, offset, length, this._targetFile);
                this._messages.add(message);
            }
            ((EvaluationTracker)data).setType((SignatureBasedType)operator.perform(choiceArg, whenTrueArg, whenFalseArg));
        } else {
            ((EvaluationTracker)data).setType(null);
        }
        return data;
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTFunctionInvocation node, Object data) {
        Object retVal = node.childrenAccept((JSPELParserVisitor)this, data);
        ((EvaluationTracker)data).setType(null);
        return retVal;
    }

    public Object visit(ASTLiteral node, Object data) {
        if (node.jjtGetNumChildren() > 0) {
            throw new AssertionError((Object)"Literals should be terminal");
        }
        BooleanLiteralType type = null;
        Token literalToken = node.getFirstToken();
        switch (literalToken.kind) {
            case 8: {
                type = new StringLiteralType(this.stripQuotes(literalToken.image));
                break;
            }
            case 5: {
                type = new IntegerLiteralType(Long.parseLong(literalToken.image));
                break;
            }
            case 6: {
                type = new FloatLiteralType(Double.parseDouble(literalToken.image));
                break;
            }
            case 11: {
                type = BooleanLiteralType.FALSE;
                break;
            }
            case 10: {
                type = BooleanLiteralType.TRUE;
                break;
            }
            case 12: {
                type = NullLiteralType.SINGLETON;
            }
        }
        ((EvaluationTracker)data).setType((SignatureBasedType)type);
        return data;
    }

    private String stripQuotes(String stringLiteral) {
        if (stringLiteral.startsWith("'") || stringLiteral.startsWith("\"")) {
            if (stringLiteral.length() > 2) {
                return stringLiteral.substring(1, stringLiteral.length() - 1);
            }
            return "";
        }
        return stringLiteral;
    }

    public Object visit(ASTMultiplyExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTOrExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        Token firstToken;
        node.childrenAccept((JSPELParserVisitor)this, data);
        SignatureBasedType type = ((EvaluationTracker)data).getType();
        if (type != null && UnaryOperator.isUnaryOperator(firstToken = node.getFirstToken())) {
            if (type instanceof ValueType) {
                UnaryOperator unaryOp = UnaryOperator.createUnaryOperator(firstToken);
                Diagnostic diagnostic = unaryOp.validate((ValueType)type);
                if (diagnostic.getSeverity() != 0) {
                    int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                    int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                    Message message = ValidationMessageFactory.createFromDiagnostic(diagnostic, offset, length, this._targetFile);
                    this._messages.add(message);
                }
                ((EvaluationTracker)data).setType((SignatureBasedType)unaryOp.performOperation((ValueType)type));
            } else {
                int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                Message message = ValidationMessageFactory.create_CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING(offset, length, this._targetFile);
                this._messages.add(message);
            }
        }
        return data;
    }

    public Object visit(ASTValue node, Object data) {
        SignatureBasedType type;
        ValueExpressionTracker tracker = new ValueExpressionTracker(this._targetFile.getProject());
        ((EvaluationTracker)data).setValueTracker(tracker);
        node.childrenAccept((JSPELParserVisitor)this, data);
        if (!tracker.isErrorFlag() && tracker.getCurMemberSymbol() instanceof IPropertySymbol && ((IPropertySymbol)tracker.getCurMemberSymbol()).isIntermediate()) {
            int problemStartOffset = tracker.getCurPropertySymbolOffset();
            int length = tracker.getCurPropertySymbolLength();
            Message message = ValidationMessageFactory.create_MEMBER_NOT_FOUND(problemStartOffset, length, this._targetFile, tracker.getCurMemberSymbol().getName(), tracker.getRootSymbol().getName());
            this._messages.add(message);
        } else if (tracker.isRootValid() && !tracker.isErrorFlag() && (type = tracker.resolveType()) != null) {
            ((EvaluationTracker)data).setType(type);
        }
        return data;
    }

    public Object visit(ASTValuePrefix node, Object data) {
        ValueExpressionTracker tracker = ((EvaluationTracker)data).getValueTracker();
        if (!tracker.isErrorFlag() && node.jjtGetNumChildren() == 0) {
            Token token = node.getFirstToken();
            String image = token.image;
            ISymbol symbol = this._symbolResolver.getVariable(image);
            if (symbol == null) {
                int problemStartOffset = this._context.getDocumentPosition() + token.beginColumn - 1;
                int length = token.endColumn - token.beginColumn + 1;
                Message message = ValidationMessageFactory.create_VARIABLE_NOT_FOUND(problemStartOffset, length, this._targetFile, image);
                this._messages.add(message);
            } else if (symbol instanceof IInstanceSymbol) {
                tracker.setRootSymbol((IInstanceSymbol)symbol);
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTValueSuffix node, Object data) {
        ValueExpressionTracker tracker = ((EvaluationTracker)data).getValueTracker();
        if (!tracker.isErrorFlag()) {
            Token firstToken = node.getFirstToken();
            if (node.jjtGetNumChildren() == 0 && firstToken.kind == 13) {
                Token dotId = node.getLastToken();
                if (tracker.isRootValid()) {
                    int startOffset = this._context.getDocumentPosition() + dotId.beginColumn - 1;
                    int length = dotId.endColumn - dotId.beginColumn + 1;
                    if (!tracker.isValidMemberOfCurrentSymbol(dotId.image)) {
                        String ownerName = tracker.getCurMemberSymbol() != null ? tracker.getCurMemberSymbol().getName() : tracker.getRootSymbol().getName();
                        Message message = ValidationMessageFactory.create_MEMBER_NOT_FOUND(startOffset, length, this._targetFile, dotId.image, ownerName);
                        this._messages.add(message);
                        tracker.setErrorFlag(true);
                    } else {
                        tracker.setCurMemberSymbol(tracker.getNextPropertySymbol(dotId.image), startOffset, length);
                    }
                }
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(SimpleNode node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public void reportFindings(IValidator validator, IReporter reporter) {
        Iterator it = this._messages.iterator();
        while (it.hasNext()) {
            reporter.addMessage(validator, (IMessage)it.next());
        }
    }

    private void performBinaryEvaluation(ASTOperatorExpression node, EvaluationTracker tracker) {
        if (node.jjtGetNumChildren() < 2) {
            throw new AssertionError((Object)"Binary operators should always have at least two sub-expressions");
        }
        if (node.getOperatorTokens().size() != node.jjtGetNumChildren() - 1) {
            throw new AssertionError((Object)"Binary operators should always have one operator token less than number of sub-expressions");
        }
        node.jjtGetChild(0).jjtAccept((JSPELParserVisitor)this, (Object)tracker);
        ValueType curType = tracker.getValueType();
        int child = 1;
        while (child < node.jjtGetNumChildren()) {
            node.jjtGetChild(child).jjtAccept((JSPELParserVisitor)this, (Object)tracker);
            ValueType secondType = tracker.getValueType();
            if (curType != null && secondType != null) {
                BinaryOperator operator = BinaryOperator.getBinaryOperator((Token)node.getOperatorTokens().get(child - 1));
                Diagnostic diagnostic = operator.validate(curType, secondType);
                if (diagnostic.getSeverity() != 0) {
                    Token firstToken = node.getFirstToken();
                    int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                    int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                    Message message = ValidationMessageFactory.createFromDiagnostic(diagnostic, offset, length, this._targetFile);
                    this._messages.add(message);
                }
                curType = operator.performOperation(curType, secondType);
            }
            ++child;
        }
        tracker.setType((SignatureBasedType)curType);
    }

    public List getMessages() {
        return this._messages;
    }

    public SignatureBasedType getExpressionType() {
        return this._tracker.getType();
    }

    public static void main(String[] args) throws IOException {
        int nextCharacter;
        String elText = "";
        while ((nextCharacter = System.in.read()) != -1) {
            char nextChar = (char)nextCharacter;
            if (nextChar == '\n') {
                try {
                    JSPELParser parser = JSPELParser.createParser((String)elText);
                    ASTExpression expr = parser.Expression();
                    expr.dump("");
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                elText = "";
                continue;
            }
            elText = String.valueOf(elText) + nextChar;
        }
    }
}

