/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.diagnostics;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.Messages;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.MyLocalizedMessage;
import org.eclipse.wst.validation.internal.core.Message;

public final class ValidationMessageFactory {
    public static Message create_CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING(int offset, int length, IFile targetFile) {
        MyLocalizedMessage message = new MyLocalizedMessage(1, Messages.CANNOT_APPLY_OPERATORS_TO_MB, (IResource)targetFile, 0);
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    public static Message create_MEMBER_NOT_FOUND(int offset, int length, IFile targetFile, String curMemberSymbol, String owningMember) {
        MyLocalizedMessage message = new MyLocalizedMessage(2, Messages.bind((String)Messages.VM_PROP_NAME_NOT_FOUND, (Object)curMemberSymbol, (Object)owningMember), (IResource)targetFile, 0);
        message.setOffset(offset);
        message.setLength(length);
        message.setAttribute("name", curMemberSymbol);
        return message;
    }

    public static Message create_VARIABLE_NOT_FOUND(int offset, int length, IFile targetFile, String variableName) {
        MyLocalizedMessage message = new MyLocalizedMessage(2, Messages.bind((String)Messages.VM_ROOT_NAME_NOT_FOUND, (Object)variableName), (IResource)targetFile, 0);
        message.setOffset(offset);
        message.setLength(length);
        message.setAttribute("name", variableName);
        return message;
    }

    public static Message create_MISSING_CLOSING_EXPR_BRACKET(int offset, int length, IFile file) {
        MyLocalizedMessage message = new MyLocalizedMessage(1, Messages.MISSING_CLOSING_EXPR_BRACKET, (IResource)file, 0);
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    public static Message create_GENERAL_SYNTAX_ERROR(int offset, int length, IFile file) {
        MyLocalizedMessage message = new MyLocalizedMessage(2, Messages.GENERAL_SYNTAX_ERROR, (IResource)file, 0);
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    public static Message create_EMPTY_EL_EXPRESSION(int offset, int length, IFile file) {
        MyLocalizedMessage message = new MyLocalizedMessage(2, Messages.EMPTY_EL_EXPRESSION, (IResource)file, 0);
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    public static Message createFromDiagnostic(Diagnostic diagnostic, int offset, int length, IFile file) {
        MyLocalizedMessage message = new MyLocalizedMessage(ValidationMessageFactory.convertSeverity(diagnostic), diagnostic.getMessage(), (IResource)file, diagnostic.getCode());
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    private static int convertSeverity(Diagnostic diagnostic) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 4;
    }

    private ValidationMessageFactory() {
    }
}

