/*******************************************************************************
 * Copyright (c) 2006 Oracle Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Cameron Bateman/Oracle - initial API and implementation
 *    
 ********************************************************************************/
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaTypeDescriptor2;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>IJava Type Descriptor2</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IJavaTypeDescriptor2Impl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IJavaTypeDescriptor2Impl#getBeanProperties <em>Bean Properties</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IJavaTypeDescriptor2Impl#getBeanMethods <em>Bean Methods</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IJavaTypeDescriptor2Impl extends ITypeDescriptorImpl implements IJavaTypeDescriptor2 {

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright 2006 Oracle";

	private final static String GET_PREFIX = "get";
	private final static String SET_PREFIX = "set";

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected static final IType TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected IType type = TYPE_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IJavaTypeDescriptor2Impl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * @return the static class 
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass() {
        return SymbolPackage.Literals.IJAVA_TYPE_DESCRIPTOR2;
    }

    /**
     * <!-- begin-user-doc -->
     * @return the JDT type descriptor 
	 * <!-- end-user-doc -->
     * @generated
     */
	public IType getType() {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
     * @param newType 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setType(IType newType) {
        IType oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__TYPE, oldType, type));
    }

	public EList getInterfaceTypeSignatures() 
    {
        EList  interfaces = new BasicEList();
        
        IType type = getType();
        
        if (type != null)
        {
            // TODO: type hierarchy is potentially expensive, should
            // cache once and listen for changes
            try {
                final ITypeHierarchy  hierarchy = 
                    type.newSupertypeHierarchy(new NullProgressMonitor());
                final IType[] interfaceTypes = hierarchy.getAllInterfaces();
                copySignatures(interfaces, interfaceTypes);
            } catch (JavaModelException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }
        
        return interfaces;
    }

    public EList getSuperTypeSignatures() 
    {
        EList  interfaces = new BasicEList();
        
        IType type = getType();
        
        if (type != null)
        {
            // TODO: type hierarchy is potentially expensive, should
            // cache once and listen for changes
            try {
                final ITypeHierarchy  hierarchy = 
                    type.newSupertypeHierarchy(new NullProgressMonitor());
                final IType[] interfaceTypes = hierarchy.getAllSuperclasses(type);
                copySignatures(interfaces, interfaceTypes);
            } catch (JavaModelException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        
        return interfaces;
    }
    
    
    private void copySignatures(List  list, IType[]  types)
    {
        for (int i = 0; i < types.length; i++)
        {
            final IType type = types[i];
            final String signature = TypeUtil.getSignature(type);
            
            if (signature != null)
            {
                list.add(signature);
            }
        }
    }

    public EList getProperties() 
    {
        return getBeanProperties();
    }

    
    public EList getMethods() 
    {
        return getBeanMethods();
    }

    /**
	 * <!-- begin-user-doc -->
     * @return the bean props for this java type 
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getBeanProperties() {
		BasicEList list = new BasicEList();
		list.addAll(getPropertiesInternal());
		return list;
	}

	/**
	 * <!-- begin-user-doc -->
     * @return the bean methods for this type  
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getBeanMethods() {
		BasicEList list = new BasicEList();
		list.addAll(getMethodsInternal());
		return list;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jst.jsf.context.symbol.internal.impl.ITypeDescriptorImpl#getTypeSignature()
     * @generated NOT
	 */
	public String getTypeSignature() 
    {
        if (getType() == null)
        {
            if (eIsSet(SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__TYPE_SIGNATURE_DELEGATE))
            {
                return getTypeSignatureDelegate();
            }

            return null;
        }
       
        return TypeUtil.getSignature(getType());
    }

    private Collection getPropertiesInternal()
	{
		IMethod[] methods = null;
		
		try
		{
            IType type = getType();
            
            // type not resolved so don't proceed
            if (type == null) return Collections.EMPTY_LIST;

            // TODO: type hierarchy is potentially expensive, should
            // cache once and listen for changes
            ITypeHierarchy  hierarchy = type.newSupertypeHierarchy(new NullProgressMonitor());
            
			methods = TypeUtil.getAllMethods(hierarchy, type);
		}
		catch(JavaModelException jme)
		{
			// if can't find methods, don't proceed
			return Collections.EMPTY_LIST;
		}
		
		final Map properties = new HashMap();
		
		for (int i = 0; i < methods.length; i++)
		{
			IMethod method = methods[i];
			
			try
			{
				// to be a bean method, it must not a constructor, must be public
				// and must not be static
				if (!method.isConstructor()
						&& (method.getFlags() & Flags.AccPublic) != 0
						&& (method.getFlags() & Flags.AccStatic) == 0)
				{
					final String methodName = method.getElementName();

					boolean  startsWithGet = methodName.startsWith(GET_PREFIX);
					boolean  startsWithSet = methodName.startsWith(SET_PREFIX);
					
					if (startsWithGet || startsWithSet)
					{
						final String propertyName = 
							Introspector.decapitalize(methodName.substring(3));
						
						IBeanPropertySymbol workingCopy =
							(IBeanPropertySymbol) properties.get(propertyName);
						
						if (workingCopy == null)
						{
							workingCopy = SymbolFactory.eINSTANCE.createIBeanPropertySymbol();
							workingCopy.setName(propertyName);
							workingCopy.setOwner(this);
                            
							properties.put(propertyName, workingCopy);
                        }
                        
                        IJavaTypeDescriptor2 workingCopyDesc =
                            (IJavaTypeDescriptor2) workingCopy.getTypeDescriptor();
						
						if (startsWithGet)
						{
							workingCopy.setReadable(true);
                            
                            if (workingCopyDesc == null)
                            {
                                workingCopyDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                                workingCopy.setTypeDescriptor(workingCopyDesc);
                            }
                            
                            final String signature = TypeUtil.
                                resolveTypeSignature(
                                        getType(), method.getReturnType());
                            final IType newType = TypeUtil.resolveType(getType(), signature);
                            
                            if (workingCopyDesc.getType() == null)
                            {
                                if (newType != null)
                                {
                                    workingCopyDesc.setType(newType);
                                }
                                else
                                {
                                    workingCopyDesc.setTypeSignatureDelegate(signature);
                                }
                            }
						}
						
						if (startsWithSet)
						{
							workingCopy.setWritable(true);
                            
                            if (workingCopyDesc == null)
                            {
                                workingCopyDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                                workingCopy.setTypeDescriptor(workingCopyDesc);
                            }
                            
                            final String[] parameters = method.getParameterTypes();
                            
                            if (parameters != null
                                    && parameters.length == 1)
                            {
                                final String argSignature = parameters[0];
                                final IType newType = TypeUtil.resolveType(getType(), argSignature);
                                
                                if (workingCopyDesc.getType() == null)
                                {
                                    if (newType != null)
                                    {
                                        workingCopyDesc.setType(newType);
                                    }
                                    else
                                    {
                                        workingCopyDesc.setTypeSignatureDelegate
                                            (argSignature);
                                    }
                                }
                            }
						}
					}
				}
			}
			catch (JavaModelException jme)
			{
				// ignore this method
			}
		}

		return properties.values();
	}

    private Collection getMethodsInternal()
	{
        if (getType() == null)
        {
            return Collections.EMPTY_LIST;
        }
        
		IMethod[] methods = null;
		
		try
		{
            // TODO: cache this hierachy
            final ITypeHierarchy  hierarchy = 
                type.newSupertypeHierarchy(new NullProgressMonitor());
			methods = TypeUtil.getAllMethods(hierarchy, getType());
		}
		catch(JavaModelException jme)
		{
			// if can't find methods, don't proceed
			return Collections.EMPTY_LIST;
		}

        List methodSymbol = new ArrayList();

		for (int i = 0; i < methods.length; i++)
		{
			IMethod method = methods[i];
			
			try
			{
				// to be a bean method, it must not a constructor, must be public
				// and must not be static
				if (!method.isConstructor()
						&& (method.getFlags() & Flags.AccPublic) != 0
						&& (method.getFlags() & Flags.AccStatic) == 0)
				{
					String methodName = method.getElementName();
					IBeanMethodSymbol workingCopy = SymbolFactory.eINSTANCE.createIBeanMethodSymbol();
					workingCopy.setName(methodName);
					workingCopy.setOwner(this);
                    workingCopy.setSignature(TypeUtil.
                                                resolveMethodSignature
                                                    (getType(), 
                                                     method.getSignature()));
					methodSymbol.add(workingCopy);
				}
			}
			catch (JavaModelException jme)
			{
				// error reading meta-data.  Skip to next one
			}
		}
		
		return methodSymbol;
	}

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
     * @param resolve 
     * @param coreType 
     * @return the value of featureID 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__TYPE:
                return getType();
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_PROPERTIES:
                return getBeanProperties();
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_METHODS:
                return getBeanMethods();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
     * @param newValue 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__TYPE:
                setType((IType)newValue);
                return;
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_PROPERTIES:
                getBeanProperties().clear();
                getBeanProperties().addAll((Collection)newValue);
                return;
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_METHODS:
                getBeanMethods().clear();
                getBeanMethods().addAll((Collection)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(int featureID) {
        switch (featureID) {
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__TYPE:
                setType(TYPE_EDEFAULT);
                return;
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_PROPERTIES:
                getBeanProperties().clear();
                return;
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_METHODS:
                getBeanMethods().clear();
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
     * @return true if the feature is set 
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__TYPE:
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_PROPERTIES:
                return !getBeanProperties().isEmpty();
            case SymbolPackage.IJAVA_TYPE_DESCRIPTOR2__BEAN_METHODS:
                return !getBeanMethods().isEmpty();
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * @return the default string rep 
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

} //IJavaTypeDescriptor2Impl
