/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProjectDescription {
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static boolean _debugIndexTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indextime"));
    private static final String WEB_INF = "WEB-INF";
    private static final IPath WEB_INF_PATH = new Path("WEB-INF");
    private static final String WEB_XML = "web.xml";
    Hashtable fClasspathJars;
    Stack fClasspathProjects = null;
    Hashtable fClasspathReferences;
    Hashtable fImplicitReferences;
    Hashtable fJARReferences;
    IProject fProject;
    Hashtable fTagDirReferences;
    Hashtable fTLDReferences;
    IResourceDeltaVisitor fVisitor;
    Hashtable fWebXMLReferences;
    private long time0;

    ProjectDescription(IProject project) {
        this.fProject = project;
        this.fClasspathReferences = new Hashtable(0);
        this.fClasspathJars = new Hashtable(0);
        this.fJARReferences = new Hashtable(0);
        this.fTagDirReferences = new Hashtable(0);
        this.fTLDReferences = new Hashtable(0);
        this.fWebXMLReferences = new Hashtable(0);
        this.fImplicitReferences = new Hashtable(0);
    }

    private Collection _getJSP11JarReferences(Collection allJARs) {
        ArrayList<JarRecord> collection = new ArrayList<JarRecord>(allJARs.size());
        Iterator i = allJARs.iterator();
        while (i.hasNext()) {
            JarRecord record = (JarRecord)i.next();
            if (!record.has11TLD) continue;
            collection.add(record);
        }
        return collection;
    }

    void clear() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITaglibRecord createCatalogRecord(String urlString) {
        ITaglibRecord record = null;
        if (urlString.toLowerCase(Locale.US).endsWith(".jar") && urlString.startsWith("file:")) {
            String fileLocation = null;
            try {
                URL url = new URL(urlString);
                fileLocation = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            if (fileLocation == null) return record;
            JarRecord jarRecord = this.createJARRecord(fileLocation);
            String[] entries = JarUtilities.getEntryNames((String)fileLocation);
            int jEntry = 0;
            while (true) {
                if (jEntry >= entries.length) {
                    if (!jarRecord.has11TLD) return record;
                    if (!_debugIndexCreation) return jarRecord;
                    Logger.log(201, "created catalog record for " + urlString + "@" + jarRecord.getLocation());
                    return jarRecord;
                }
                if (entries[jEntry].endsWith(".tld") && entries[jEntry].equals("META-INF/taglib.tld")) {
                    jarRecord.has11TLD = true;
                    InputStream contents = JarUtilities.getInputStream((String)fileLocation, (String)entries[jEntry]);
                    if (contents != null) {
                        TaglibInfo info;
                        jarRecord.info = info = this.extractInfo(fileLocation, contents);
                    }
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
                ++jEntry;
            }
        }
        URL url = null;
        ByteArrayInputStream cachedContents = null;
        InputStream tldStream = null;
        try {
            url = new URL(urlString);
            URLConnection connection = url.openConnection();
            connection.setDefaultUseCaches(false);
            tldStream = connection.getInputStream();
        }
        catch (Exception e1) {
            Logger.logException(e1);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = new byte[2048];
        try {
            try {
                while (true) {
                    int c;
                    if ((c = tldStream.read(bytes)) < 0) {
                        cachedContents = new ByteArrayInputStream(buffer.toByteArray());
                    }
                    buffer.write(bytes, 0, c);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            try {
                tldStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_20 = null;
        }
        try {}
        catch (IOException iOException) {}
        tldStream.close();
        URLRecord urlRecord = null;
        TaglibInfo info = this.extractInfo(urlString, cachedContents);
        if (info != null) {
            urlRecord = new URLRecord();
            urlRecord.info = info;
            urlRecord.baseLocation = urlString;
            urlRecord.url = url;
        }
        try {
            cachedContents.close();
            return urlRecord;
        }
        catch (IOException iOException) {}
        return urlRecord;
    }

    private JarRecord createJARRecord(IResource jar) {
        return this.createJARRecord(jar.getLocation().toString());
    }

    private JarRecord createJARRecord(String fileLocation) {
        JarRecord record = new JarRecord();
        record.location = new Path(fileLocation);
        record.urlRecords = new ArrayList(0);
        return record;
    }

    TagDirRecord createTagdirRecord(IResource tagFile) {
        IContainer tagdir = tagFile.getParent();
        String tagdirLocation = tagdir.getFullPath().toString();
        TagDirRecord record = (TagDirRecord)this.fTagDirReferences.get(tagdirLocation);
        if (record == null) {
            record = new TagDirRecord();
            record.location = tagdir.getFullPath();
            if (tagdir.getName().equals("tags")) {
                record.shortName = "tags";
            } else {
                IPath tagdirPath = tagdir.getFullPath();
                String[] segments = tagdirPath.segments();
                int i = 1;
                while (record.shortName == null && i < segments.length) {
                    if (segments[i - 1].equals(WEB_INF) && segments[i].equals("tags")) {
                        IPath tagdirLocalPath = tagdirPath.removeFirstSegments(i + 1);
                        record.shortName = tagdirLocalPath.toString().replace('/', '-');
                    }
                    ++i;
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TLDRecord createTLDRecord(IResource tld) {
        TLDRecord record = new TLDRecord();
        record.path = tld.getFullPath();
        InputStream contents = null;
        try {
            try {
                if (tld.getLocation() != null) {
                    contents = ((IFile)tld).getContents(true);
                    String baseLocation = tld.getLocation().toString();
                    TaglibInfo info = this.extractInfo(baseLocation, contents);
                    if (info != null) {
                        record.info = info;
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (contents == null) throw throwable;
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return record;
        }
        if (contents == null) return record;
        contents.close();
        return record;
    }

    private TaglibInfo extractInfo(String baseLocation, InputStream tldContents) {
        TaglibInfo info = new TaglibInfo();
        if (tldContents != null) {
            DocumentProvider provider = new DocumentProvider();
            provider.setInputStream(tldContents);
            provider.setValidating(false);
            provider.setRootElementName("taglib");
            provider.setBaseReference(baseLocation);
            Node child = provider.getRootElement();
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("taglib")) {
                return null;
            }
            child = child.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    if (child.getNodeName().equals("uri")) {
                        info.uri = this.getTextContents(child);
                    } else if (child.getNodeName().equals("short-name") || child.getNodeName().equals("shortname")) {
                        info.shortName = this.getTextContents(child);
                    } else if (child.getNodeName().equals("description") || child.getNodeName().equals("info")) {
                        info.description = this.getTextContents(child);
                    } else if (child.getNodeName().equals("jsp-version") || child.getNodeName().equals("jspversion")) {
                        try {
                            info.jspVersion = Float.parseFloat(this.getTextContents(child));
                        }
                        catch (NumberFormatException numberFormatException) {
                            info.jspVersion = 1.0f;
                        }
                    } else if (child.getNodeName().equals("tlib-version") || child.getNodeName().equals("tlibversion")) {
                        info.tlibVersion = this.getTextContents(child);
                    } else if (child.getNodeName().equals("small-icon")) {
                        info.smallIcon = this.getTextContents(child);
                    } else if (child.getNodeName().equals("large-icon")) {
                        info.largeIcon = this.getTextContents(child);
                    }
                }
                child = child.getNextSibling();
            }
        }
        return info;
    }

    synchronized List getAvailableTaglibRecords(IPath path) {
        Collection implicitReferences = this.getImplicitReferences(path.toString()).values();
        ArrayList records = new ArrayList(this.fTLDReferences.size() + this.fTagDirReferences.size() + this.fJARReferences.size() + this.fWebXMLReferences.size());
        records.addAll(this.fTLDReferences.values());
        records.addAll(this.fTagDirReferences.values());
        records.addAll(this._getJSP11JarReferences(this.fJARReferences.values()));
        records.addAll(this.fClasspathReferences.values());
        records.addAll(implicitReferences);
        return records;
    }

    Hashtable getImplicitReferences(String path) {
        String localRoot = this.getLocalRoot(path);
        Hashtable implicitReferences = (Hashtable)this.fImplicitReferences.get(localRoot);
        if (implicitReferences == null) {
            implicitReferences = new Hashtable(1);
            this.fImplicitReferences.put(localRoot, implicitReferences);
        }
        return implicitReferences;
    }

    IPath getLocalRoot(IPath basePath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = null;
        if (file == null) {
            IFile[] files = workspaceRoot.findFilesForLocation(basePath.makeAbsolute());
            int i = 0;
            while (file == null && i < files.length) {
                IPath normalizedPath = null;
                if (files[i].exists() && (normalizedPath = files[i].getFullPath()).segmentCount() > 1 && normalizedPath.segment(0).equals(this.fProject.getFullPath().segment(0))) {
                    file = workspaceRoot.getFile(normalizedPath);
                }
                ++i;
            }
        }
        if (file == null) {
            file = FileBuffers.getWorkspaceFileAtLocation((IPath)basePath);
        }
        if (basePath.segmentCount() > 1) {
            file = workspaceRoot.getFolder(basePath);
        }
        if (file != null && !file.exists()) {
            file = workspaceRoot.getFile(basePath);
        }
        while (file != null) {
            IFolder webinf;
            IContainer folder = null;
            folder = (file.getType() & 2) != 0 ? (IContainer)file : file.getParent();
            if (folder != null && (folder.getType() & 8) == 0 && (webinf = folder.getFolder(WEB_INF_PATH)) != null && webinf.exists()) {
                return folder.getFullPath();
            }
            file = file.getParent();
        }
        return this.fProject.getFullPath();
    }

    private String getLocalRoot(String basePath) {
        return this.getLocalRoot((IPath)new Path(basePath)).toString();
    }

    private String getTextContents(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new DeltaVisitor();
        }
        return this.fVisitor;
    }

    void index() {
        this.time0 = System.currentTimeMillis();
        this.fTLDReferences.clear();
        this.fJARReferences.clear();
        this.fTagDirReferences.clear();
        this.fWebXMLReferences.clear();
        try {
            this.fProject.accept((IResourceProxyVisitor)new Indexer(), 0);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (_debugIndexTime) {
            Logger.log(201, "indexed " + this.fProject.getName() + " contents in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    void indexClasspath() {
        this.time0 = System.currentTimeMillis();
        this.fClasspathProjects = new Stack();
        this.fClasspathReferences.clear();
        this.fClasspathJars.clear();
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        this.indexClasspath(javaProject);
        if (_debugIndexTime) {
            Logger.log(201, "indexed " + this.fProject.getName() + " classpath in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    private void indexClasspath(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 5: {
                IClasspathContainer container = (IClasspathContainer)entry;
                IClasspathEntry[] containedEntries = container.getClasspathEntries();
                int i = 0;
                while (i < containedEntries.length) {
                    this.indexClasspath(containedEntries[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                IPath libPath;
                if (this.fClasspathProjects.size() >= 2 && !entry.isExported() || this.fClasspathJars.containsKey((libPath = entry.getPath()).toString())) break;
                if (libPath.toFile().exists()) {
                    this.updateClasspathLibrary(libPath.toString(), 4);
                    break;
                }
                IFile libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath);
                if (libFile == null || !libFile.exists()) break;
                this.updateClasspathLibrary(libFile.getLocation().toString(), 4);
                break;
            }
            case 2: {
                IProject project;
                if (this.fClasspathProjects.size() >= 2 && !entry.isExported() || (project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) == null || this.fClasspathProjects.contains(project.getName())) break;
                this.indexClasspath(JavaCore.create((IProject)project));
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void indexClasspath(IJavaProject javaProject) {
        if (javaProject != null && javaProject.exists() && !this.fClasspathProjects.contains(javaProject.getElementName())) {
            this.fClasspathProjects.push(javaProject.getElementName());
            try {
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    this.indexClasspath(entries[i]);
                    ++i;
                }
            }
            catch (JavaModelException e) {
                Logger.logException("Error searching Java Build Path + (" + this.fProject.getName() + ") for tag libraries", e);
            }
            this.fClasspathProjects.pop();
        }
    }

    private String readTextofChild(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                return this.getTextContents(child);
            }
            ++i;
        }
        return "";
    }

    void removeJAR(IResource jar) {
        JarRecord record;
        if (_debugIndexCreation) {
            Logger.log(201, "removing records for JAR " + jar.getFullPath());
        }
        if ((record = (JarRecord)this.fJARReferences.remove(jar.getFullPath().toString())) != null) {
            URLRecord[] records = record.getURLRecords().toArray(new URLRecord[0]);
            int i = 0;
            while (i < records.length) {
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(records[i], 2));
                this.getImplicitReferences(jar.getFullPath().toString()).remove(records[i].getURI());
                ++i;
            }
            if (record.has11TLD) {
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
            }
        }
    }

    void removeTagDir(IResource tagFile) {
    }

    void removeTLD(IResource tld) {
        TLDRecord record;
        if (_debugIndexCreation) {
            Logger.log(201, "removing record for " + tld.getFullPath());
        }
        if ((record = (TLDRecord)this.fTLDReferences.remove(tld.getFullPath())) != null) {
            if (record.getURI() != null) {
                this.getImplicitReferences(tld.getFullPath().toString()).remove(record.getURI());
            }
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
        }
    }

    void removeWebXML(IResource webxml) {
        WebXMLRecord record;
        if (_debugIndexCreation) {
            Logger.log(201, "removing records for " + webxml.getFullPath());
        }
        if ((record = (WebXMLRecord)this.fWebXMLReferences.remove(webxml.getLocation().toString())) != null) {
            TLDRecord[] records = record.getTLDRecords().toArray(new TLDRecord[0]);
            int i = 0;
            while (i < records.length) {
                if (_debugIndexCreation) {
                    Logger.log(201, "removed record for " + records[i].getURI() + "@" + records[i].path);
                }
                this.getImplicitReferences(webxml.getFullPath().toString()).remove(records[i].getURI());
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(records[i], 2));
                ++i;
            }
        }
    }

    ITaglibRecord resolve(String basePath, String reference) {
        ICatalog catalog;
        ITaglibRecord record = null;
        String path = null;
        path = reference.startsWith("/") ? String.valueOf(this.getLocalRoot(basePath)) + reference : URIHelper.normalize((String)reference, (String)basePath, (String)this.getLocalRoot(basePath));
        if (record == null && (record = (ITaglibRecord)this.fJARReferences.get(path)) instanceof JarRecord && !((JarRecord)record).has11TLD) {
            record = null;
        }
        if (record == null) {
            record = (ITaglibRecord)this.fTLDReferences.get(path);
        }
        if (record == null) {
            record = (ITaglibRecord)this.getImplicitReferences(basePath).get(reference);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fTagDirReferences.get(path);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fClasspathReferences.get(reference);
        }
        if (record == null && (catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog()) != null) {
            String resolvedString = null;
            try {
                resolvedString = catalog.resolveSystem(reference);
                if (resolvedString == null || resolvedString.trim().length() == 0) {
                    resolvedString = catalog.resolveURI(reference);
                }
                if (resolvedString == null || resolvedString.trim().length() == 0) {
                    resolvedString = catalog.resolvePublic(reference, basePath);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            if (resolvedString != null && resolvedString.trim().length() > 0) {
                record = this.createCatalogRecord(resolvedString);
            }
        }
        if (record == null && this.fProject.getFullPath().toString().equals(this.getLocalRoot(basePath))) {
            WebXMLRecord[] webxmls = this.fWebXMLReferences.values().toArray(new WebXMLRecord[0]);
            int i = 0;
            while (i < webxmls.length) {
                if (record == null) {
                    record = (ITaglibRecord)this.getImplicitReferences(webxmls[i].path.toString()).get(reference);
                }
                ++i;
            }
        }
        return record;
    }

    void updateClasspathLibrary(String libraryLocation, int deltaKind) {
        String[] entries = JarUtilities.getEntryNames((String)libraryLocation);
        JarRecord libraryRecord = this.createJARRecord(libraryLocation);
        this.fClasspathJars.put(libraryLocation, libraryRecord);
        int i = 0;
        while (i < entries.length) {
            InputStream contents;
            if (entries[i].equals("META-INF/taglib.tld")) {
                libraryRecord.has11TLD = true;
            }
            if (entries[i].endsWith(".tld") && (contents = JarUtilities.getInputStream((String)libraryLocation, (String)entries[i])) != null) {
                TaglibInfo info = this.extractInfo(libraryLocation, contents);
                if (info != null && info.uri != null && info.uri.length() > 0) {
                    URLRecord record = new URLRecord();
                    record.info = info;
                    record.baseLocation = libraryLocation;
                    try {
                        record.url = new URL("jar:file:" + libraryLocation + "!/" + entries[i]);
                        libraryRecord.urlRecords.add(record);
                        this.fClasspathReferences.put(record.getURI(), record);
                        if (_debugIndexCreation) {
                            Logger.log(201, "created record for " + record.getURI() + "@" + record.getURL());
                        }
                    }
                    catch (MalformedURLException e) {
                        Logger.logException(e);
                    }
                }
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(libraryRecord, deltaKind));
    }

    void updateJAR(IResource jar, int deltaKind) {
        if (_debugIndexCreation) {
            Logger.log(201, "creating records for JAR " + jar.getFullPath());
        }
        String jarLocationString = jar.getLocation().toString();
        String[] entries = JarUtilities.getEntryNames((IResource)jar);
        JarRecord jarRecord = this.createJARRecord(jar);
        this.fJARReferences.put(jar.getFullPath().toString(), jarRecord);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].endsWith(".tld")) {
                InputStream contents;
                if (entries[i].equals("META-INF/taglib.tld")) {
                    jarRecord.has11TLD = true;
                }
                if ((contents = JarUtilities.getInputStream((IResource)jar, (String)entries[i])) != null) {
                    TaglibInfo info = this.extractInfo(jarLocationString, contents);
                    if (info != null && info.uri != null && info.uri.length() > 0) {
                        URLRecord record = new URLRecord();
                        record.info = info;
                        record.baseLocation = jarLocationString;
                        try {
                            record.url = new URL("jar:file:" + jarLocationString + "!/" + entries[i]);
                            jarRecord.urlRecords.add(record);
                            this.getImplicitReferences(jar.getFullPath().toString()).put(record.getURI(), record);
                            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 1));
                            if (_debugIndexCreation) {
                                Logger.log(201, "created record for " + record.getURI() + "@" + record.getURL());
                            }
                        }
                        catch (MalformedURLException e) {
                            Logger.logException(e);
                        }
                    }
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    Logger.log(4, String.valueOf(this.getClass().getName()) + "could not read resource " + jar.getFullPath());
                }
            }
            ++i;
        }
        if (jarRecord.has11TLD) {
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(jarRecord, deltaKind));
        }
    }

    void updateTagDir(IResource tagFile, int deltaKind) {
    }

    void updateTLD(IResource tld, int deltaKind) {
        if (_debugIndexCreation) {
            Logger.log(201, "creating record for " + tld.getFullPath());
        }
        TLDRecord record = this.createTLDRecord(tld);
        this.fTLDReferences.put(tld.getFullPath().toString(), record);
        if (record.getURI() != null) {
            this.getImplicitReferences(tld.getFullPath().toString()).put(record.getURI(), record);
        }
        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, deltaKind));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateWebXML(IResource webxml, int deltaKind) {
        block19: {
            if (webxml.getType() != 1) {
                return;
            }
            webxmlContents = null;
            document = null;
            try {
                try {
                    webxmlContents = ((IFile)webxml).getContents(true);
                    provider = new DocumentProvider();
                    provider.setInputStream(webxmlContents);
                    provider.setValidating(false);
                    provider.setRootElementName("web-app");
                    provider.setBaseReference(webxml.getParent().getLocation().toString());
                    document = provider.getDocument(false);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
            catch (Throwable var7_7) {
                var6_9 = null;
                if (webxmlContents == null) throw var7_7;
                try {
                    webxmlContents.close();
                    throw var7_7;
                }
                catch (IOException v0) {}
                throw var7_7;
            }
            {
                var6_10 = null;
                if (webxmlContents == null) break block19;
            }
            try {}
            catch (IOException v1) {}
            webxmlContents.close();
        }
        if (document == null) {
            return;
        }
        if (ProjectDescription._debugIndexCreation) {
            Logger.log(201, "creating records for " + webxml.getFullPath());
        }
        webxmlRecord = new WebXMLRecord();
        webxmlRecord.path = webxml.getFullPath();
        this.fWebXMLReferences.put(webxmlRecord.getWebXML().toString(), webxmlRecord);
        taglibs = document.getElementsByTagName("taglib");
        iTaglib = 0;
        while (iTaglib < taglibs.getLength()) {
            block20: {
                block22: {
                    block21: {
                        taglibUri = this.readTextofChild(taglibs.item(iTaglib), "taglib-uri").trim();
                        taglibLocation = this.readTextofChild(taglibs.item(iTaglib), "taglib-location").trim();
                        path = null;
                        path = taglibLocation.startsWith("/") != false ? new Path(String.valueOf(this.getLocalRoot(webxml.getFullPath().toString())) + taglibLocation) : new Path(URIHelper.normalize((String)taglibLocation, (String)webxml.getFullPath().toString(), (String)this.getLocalRoot(webxml.getLocation().toString())));
                        if (path.segmentCount() <= 1 || !(resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).isAccessible()) break block20;
                        record /* !! */  = null;
                        if (!resource.getFileExtension().equalsIgnoreCase("jar")) break block21;
                        jarRecord = this.createJARRecord((IResource)resource);
                        entries = JarUtilities.getEntryNames((IResource)resource);
                        jEntry = 0;
                        if (true) ** GOTO lbl73
                    }
                    record /* !! */  = tldRecord = this.createTLDRecord((IResource)resource);
                    tldRecord.info.uri = taglibUri;
                    if (ProjectDescription._debugIndexCreation) {
                        Logger.log(201, "created web.xml record for " + taglibUri + "@" + tldRecord.getPath());
                    }
                    break block22;
                    do {
                        if (entries[jEntry].endsWith(".tld") && entries[jEntry].equals("META-INF/taglib.tld")) {
                            jarRecord.has11TLD = true;
                            contents = JarUtilities.getInputStream((IResource)resource, (String)entries[jEntry]);
                            if (contents != null) {
                                jarRecord.info = info = this.extractInfo(resource.getLocation().toString(), contents);
                            }
                            try {
                                contents.close();
                            }
                            catch (IOException v2) {}
                        }
                        ++jEntry;
lbl73:
                        // 2 sources

                    } while (jEntry < entries.length);
                    record /* !! */  = jarRecord;
                    jarRecord.info.uri = taglibUri;
                    if (ProjectDescription._debugIndexCreation) {
                        Logger.log(201, "created web.xml record for " + taglibUri + "@" + jarRecord.getLocation());
                    }
                }
                webxmlRecord.tldRecords.add(record /* !! */ );
                this.getImplicitReferences(webxml.getFullPath().toString()).put(taglibUri, record /* !! */ );
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record /* !! */ , deltaKind));
            }
            ++iTaglib;
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (resource.getName().endsWith(".tld")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTLD(resource);
                    } else {
                        ProjectDescription.this.updateTLD(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".jar")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeJAR(resource);
                    } else {
                        ProjectDescription.this.updateJAR(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".tag") || resource.getName().endsWith(".tagx")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTagDir(resource);
                    } else {
                        ProjectDescription.this.updateTagDir(resource, delta.getKind());
                    }
                } else if (resource.getName().equals(ProjectDescription.WEB_XML) && resource.getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeWebXML(resource);
                    } else {
                        ProjectDescription.this.updateWebXML(resource, delta.getKind());
                    }
                }
            }
            return resource.getName().length() != 0 && resource.getName().charAt(0) != '.';
        }
    }

    class Indexer
    implements IResourceProxyVisitor {
        Indexer() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String name;
            if (proxy.getType() == 1) {
                if (proxy.getName().endsWith(".tld")) {
                    ProjectDescription.this.updateTLD(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".jar")) {
                    ProjectDescription.this.updateJAR(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".tag") || proxy.getName().endsWith(".tagx")) {
                    ProjectDescription.this.updateTagDir(proxy.requestResource(), 1);
                } else if (proxy.getName().equals(ProjectDescription.WEB_XML) && proxy.requestResource().getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    ProjectDescription.this.updateWebXML(proxy.requestResource(), 1);
                }
            }
            return (name = proxy.getName()).length() != 0 && name.charAt(0) != '.';
        }
    }

    static class JarRecord
    implements IJarRecord {
        boolean has11TLD;
        TaglibInfo info;
        IPath location;
        List urlRecords;

        JarRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JarRecord)) {
                return false;
            }
            return ((JarRecord)obj).location.equals((Object)this.location) && ((JarRecord)obj).has11TLD == this.has11TLD;
        }

        public IPath getLocation() {
            return this.location;
        }

        public int getRecordType() {
            return 2;
        }

        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public List getURLRecords() {
            return this.urlRecords;
        }

        public String toString() {
            return "JarRecord: " + this.location + " <-> " + this.urlRecords;
        }
    }

    static class TLDRecord
    implements ITLDRecord {
        TaglibInfo info;
        IPath path;

        TLDRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TLDRecord)) {
                return false;
            }
            return ((TLDRecord)obj).path.equals((Object)this.path) && ((TLDRecord)obj).getURI().equals(this.getURI());
        }

        public IPath getPath() {
            return this.path;
        }

        public int getRecordType() {
            return 1;
        }

        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public String getURI() {
            if (this.info == null) {
                return null;
            }
            return this.info.uri;
        }

        public String toString() {
            return "TLDRecord: " + this.getURI() + " <-> " + this.path;
        }
    }

    static class TagDirRecord
    implements ITagDirRecord {
        IPath location;
        String shortName;
        List tags = new ArrayList(0);

        TagDirRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagDirRecord)) {
                return false;
            }
            return ((TagDirRecord)obj).location.equals((Object)this.location);
        }

        public IPath getLocation() {
            return this.location;
        }

        public int getRecordType() {
            return 8;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String[] getTags() {
            return this.tags.toArray(new String[this.tags.size()]);
        }

        public String toString() {
            return "TagdirRecord: " + this.location + " <-> " + this.shortName;
        }
    }

    static class TaglibInfo {
        String description;
        float jspVersion;
        String largeIcon;
        String shortName;
        String smallIcon;
        String tlibVersion;
        String uri;

        TaglibInfo() {
        }
    }

    class TaglibRecordEvent
    implements ITaglibRecordEvent {
        ITaglibRecord fTaglibRecord = null;
        int fType = -1;
        static /* synthetic */ Class class$0;

        TaglibRecordEvent(ITaglibRecord record, int type) {
            this.fTaglibRecord = record;
            this.fType = type;
        }

        public ITaglibRecord getTaglibRecord() {
            return this.fTaglibRecord;
        }

        public int getType() {
            return this.fType;
        }

        public String toString() {
            String string = this.fTaglibRecord.toString();
            switch (this.fType) {
                case 1: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" ADDED (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                    break;
                }
                case 4: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" CHANGED (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                    break;
                }
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" REMOVED (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" other:").append(this.fType).append(" (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                }
            }
            return string;
        }
    }

    static class URLRecord
    implements IURLRecord {
        String baseLocation;
        TaglibInfo info;
        URL url;

        public boolean equals(Object obj) {
            if (!(obj instanceof URLRecord)) {
                return false;
            }
            return ((URLRecord)obj).baseLocation.equals(this.baseLocation) && ((URLRecord)obj).url.equals(this.url);
        }

        public String getBaseLocation() {
            return this.baseLocation;
        }

        public int getRecordType() {
            return 4;
        }

        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public String getURI() {
            if (this.info == null) {
                return "";
            }
            return this.info.uri;
        }

        public URL getURL() {
            return this.url;
        }

        public String toString() {
            return "URLRecord: " + this.baseLocation + " <-> " + this.getURI();
        }
    }

    static class WebXMLRecord {
        TaglibInfo info;
        IPath path;
        List tldRecords = new ArrayList(0);

        WebXMLRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WebXMLRecord)) {
                return false;
            }
            return ((WebXMLRecord)obj).path.equals((Object)this.path);
        }

        public String getPrefix() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public List getTLDRecords() {
            return this.tldRecords;
        }

        public IPath getWebXML() {
            return this.path;
        }

        public String toString() {
            return "WebXMLRecord: " + this.path + " " + this.tldRecords;
        }
    }
}

