/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.ServerProfiler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class TomcatLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    static /* synthetic */ Class class$0;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace(Trace.FINEST, "Launch configuration could not find server");
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TomcatServerBehaviour tomcatServer = (TomcatServerBehaviour)server.loadAdapter((Class)clazz, null);
        tomcatServer.setupLaunch(launch, mode, monitor);
        String mainTypeName = tomcatServer.getRuntimeClass();
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            runner = vm.getVMRunner("run");
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        String[] envp = this.getEnvironment(configuration);
        if ("profile".equals(mode)) {
            ServerProfiler[] sp = JavaServerPlugin.getServerProfilers();
            if (sp == null || runner == null) {
                tomcatServer.stopImpl();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorNoProfiler, null));
            }
            String vmArgs2 = sp[0].getVMArgs();
            vmArgs = String.valueOf(vmArgs) + " " + vmArgs2;
        }
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        try {
            runner.run(runConfig, launch, monitor);
            tomcatServer.setProcess(launch.getProcesses()[0]);
        }
        catch (Exception exception) {}
    }
}

