/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.DOMExtensionTreeContentProvider;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDExtensionTreeContentProvider
extends DOMExtensionTreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof XSDConcreteComponent) {
            Element element;
            XSDConcreteComponent component = (XSDConcreteComponent)inputElement;
            ArrayList<Node> elementsAndAttributes = new ArrayList<Node>();
            XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(component, false);
            if (xsdAnnotation != null) {
                EList appInfoList = xsdAnnotation.getApplicationInformation();
                Element appInfoElement = null;
                if (appInfoList.size() > 0) {
                    appInfoElement = (Element)appInfoList.get(0);
                }
                if (appInfoElement != null) {
                    Iterator it = appInfoList.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof Element)) continue;
                        Element appInfo = (Element)obj;
                        NodeList nodeList = appInfo.getChildNodes();
                        int length = nodeList.getLength();
                        int i = 0;
                        while (i < length) {
                            Node node = nodeList.item(i);
                            if (node instanceof Element) {
                                elementsAndAttributes.add(node);
                            }
                            ++i;
                        }
                    }
                }
            }
            if ((element = component.getElement()) == null) {
                return elementsAndAttributes.toArray();
            }
            NamedNodeMap attributes = component.getElement().getAttributes();
            if (attributes != null) {
                int length = attributes.getLength();
                int i = 0;
                while (i < length) {
                    Node oneAttribute = attributes.item(i);
                    if (!XSDExtensionTreeContentProvider.isXmlnsAttribute(oneAttribute)) {
                        String namespace = oneAttribute.getNamespaceURI();
                        boolean isExtension = true;
                        if (namespace == null && oneAttribute.getPrefix() == null) {
                            isExtension = false;
                        } else if (!"http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                            isExtension = true;
                        }
                        if (isExtension) {
                            elementsAndAttributes.add(oneAttribute);
                        }
                    }
                    ++i;
                }
            }
            return elementsAndAttributes.toArray();
        }
        return Collections.EMPTY_LIST.toArray();
    }

    private static boolean isXmlnsAttribute(Node attribute) {
        String prefix = attribute.getPrefix();
        if (prefix != null) {
            return "xmlns".equals(prefix);
        }
        return "xmlns".equals(attribute.getNodeName());
    }
}

