/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.integration;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.DoNotUseMeThisWillBeDeletedPost15;
import org.eclipse.wst.common.frameworks.internal.WTPProjectUtilities;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationOperation;

public class JavaProjectCreationOperation
extends ProjectCreationOperation
implements DoNotUseMeThisWillBeDeletedPost15 {
    public JavaProjectCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        super.execute(monitor, info);
        try {
            this.createJavaProject(monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return OK_STATUS;
    }

    private void createJavaProject(IProgressMonitor monitor) throws CoreException {
        IProject project = (IProject)this.model.getProperty("IProjectCreationProperties.PROJECT");
        WTPProjectUtilities.addNatureToProjectLast((IProject)project, (String)"org.eclipse.jdt.core.javanature");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(this.getOutputPath(project), monitor);
        javaProject.setRawClasspath(this.getClasspathEntries(project), monitor);
        if (this.model.getBooleanProperty("JavaProjectCreationDataModel.CREATE_SOURCE_FOLDERS")) {
            String[] sourceFolders = (String[])this.model.getProperty("JavaProjectCreationDataModel.SOURCE_FOLDERS");
            IFolder folder = null;
            int i = 0;
            while (i < sourceFolders.length) {
                folder = project.getFolder(sourceFolders[i]);
                folder.create(true, true, monitor);
                ++i;
            }
        }
    }

    private IPath getOutputPath(IProject project) {
        String outputLocation = this.model.getStringProperty("JavaProjectCreationDataModel.OUTPUT_LOCATION");
        return project.getFullPath().append(outputLocation);
    }

    private IClasspathEntry[] getClasspathEntries(IProject project) {
        IClasspathEntry[] entries = (IClasspathEntry[])this.model.getProperty("JavaProjectCreationDataModel.CLASSPATH_ENTRIES");
        IClasspathEntry[] sourceEntries = null;
        if (this.model.getBooleanProperty("JavaProjectCreationDataModel.CREATE_SOURCE_FOLDERS")) {
            sourceEntries = this.getSourceClasspathEntries(project);
        }
        return this.combineArrays(sourceEntries, entries);
    }

    private IClasspathEntry[] getSourceClasspathEntries(IProject project) {
        String[] sourceFolders = (String[])this.model.getProperty("JavaProjectCreationDataModel.SOURCE_FOLDERS");
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < sourceFolders.length) {
            list.add(JavaCore.newSourceEntry((IPath)project.getFullPath().append(sourceFolders[i])));
            ++i;
        }
        IClasspathEntry[] classpath = new IClasspathEntry[list.size()];
        int i2 = 0;
        while (i2 < classpath.length) {
            classpath[i2] = (IClasspathEntry)list.get(i2);
            ++i2;
        }
        return classpath;
    }

    private IClasspathEntry[] combineArrays(IClasspathEntry[] sourceEntries, IClasspathEntry[] entries) {
        if (sourceEntries != null) {
            if (entries == null) {
                return sourceEntries;
            }
            return this.doCombineArrays(sourceEntries, entries);
        }
        if (entries != null) {
            return entries;
        }
        return new IClasspathEntry[0];
    }

    private IClasspathEntry[] doCombineArrays(IClasspathEntry[] sourceEntries, IClasspathEntry[] entries) {
        IClasspathEntry[] result = new IClasspathEntry[sourceEntries.length + entries.length];
        System.arraycopy(sourceEntries, 0, result, 0, sourceEntries.length);
        System.arraycopy(entries, 0, result, sourceEntries.length, entries.length);
        return result;
    }
}

