/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.XMLChar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.RefactoringSection;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewTypeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDSimpleTypeSection
extends RefactoringSection {
    protected Text nameText;
    CCombo varietyCombo;
    CCombo typesCombo;
    CLabel typesLabel;
    XSDSimpleTypeDefinition memberTypeDefinition;
    XSDSimpleTypeDefinition itemTypeDefinition;
    XSDSimpleTypeDefinition baseTypeDefinition;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void createContents(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.composite = factory.createFlatFormComposite(parent);
        GridData data = new GridData();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel nameLabel = factory.createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.common.util.Messages._UI_LABEL_NAME);
        nameLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.nameText);
        this.createRenameHyperlink(this.composite);
        CLabel label = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_VARIETY"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        this.varietyCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        List list = XSDVariety.VALUES;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.varietyCombo.add(((XSDVariety)iter.next()).getName());
        }
        this.varietyCombo.addSelectionListener((SelectionListener)this);
        this.varietyCombo.setLayoutData((Object)data);
        this.getWidgetFactory().createCLabel(this.composite, "");
        this.typesLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
        this.typesCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.typesCombo.setEditable(false);
        this.typesCombo.setLayoutData((Object)data);
        this.typesCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.typesCombo.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.relayout();
    }

    protected void relayout() {
        Composite parentComposite = this.composite.getParent();
        parentComposite.getParent().setRedraw(false);
        if (parentComposite != null && !parentComposite.isDisposed()) {
            Control[] children = parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createContents(parentComposite);
        parentComposite.getParent().layout(true, true);
        parentComposite.getParent().setRedraw(true);
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.setListenerEnabled(false);
        this.nameText.setText("");
        this.varietyCombo.setText("");
        this.typesCombo.setText("");
        this.fillTypesCombo();
        this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
        if (this.input instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.input;
            String simpleTypeName = st.getName();
            if (simpleTypeName != null) {
                this.nameText.setText(simpleTypeName);
            } else {
                this.nameText.setText("**anonymous**");
            }
            String variety = st.getVariety().getName();
            int intVariety = st.getVariety().getValue();
            if (variety != null) {
                this.varietyCombo.setText(variety);
                if (intVariety == 0) {
                    this.baseTypeDefinition = st.getBaseTypeDefinition();
                    String name = "";
                    if (this.baseTypeDefinition != null) {
                        name = this.baseTypeDefinition.getName();
                    }
                    this.typesCombo.setText(name);
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
                } else if (intVariety == 1) {
                    this.itemTypeDefinition = st.getItemTypeDefinition();
                    String name = "";
                    if (this.itemTypeDefinition != null) {
                        name = this.itemTypeDefinition.getName();
                    }
                    this.typesCombo.setText(name);
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_ITEM_TYPE"));
                } else if (intVariety == 2) {
                    EList memberTypesList = st.getMemberTypeDefinitions();
                    StringBuffer sb = new StringBuffer();
                    Iterator i = memberTypesList.iterator();
                    while (i.hasNext()) {
                        XSDSimpleTypeDefinition typeObject = (XSDSimpleTypeDefinition)i.next();
                        String name = typeObject.getQName();
                        if (name == null) continue;
                        sb.append(name);
                        if (!i.hasNext()) continue;
                        sb.append(" ");
                    }
                    String memberTypes = sb.toString();
                    this.typesCombo.setText(memberTypes);
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
                }
            }
        }
        this.setListenerEnabled(true);
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.typesCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDComplexTypeBaseTypeEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.typesCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
                ((XSDSearchListDialogDelegate)dialog).showComplexTypes(false);
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
                ((NewTypeDialog)dialog).allowComplexType(false);
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        } else if (e.widget == this.varietyCombo && this.input != null && this.input instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.input;
            Element parent = st.getElement();
            String variety = this.varietyCombo.getText();
            if (variety.equals(XSDVariety.ATOMIC_LITERAL.getName())) {
                this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
                st.setVariety(XSDVariety.ATOMIC_LITERAL);
                this.addCreateElementActionIfNotExist("restriction", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_RESTRICTION"), parent, null);
            } else if (variety.equals(XSDVariety.UNION_LITERAL.getName())) {
                this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
                st.setVariety(XSDVariety.UNION_LITERAL);
                this.addCreateElementActionIfNotExist("union", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_UNION"), parent, null);
            } else if (variety.equals(XSDVariety.LIST_LITERAL.getName())) {
                this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_ITEM_TYPE"));
                st.setVariety(XSDVariety.LIST_LITERAL);
                this.addCreateElementActionIfNotExist("list", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LIST"), parent, null);
            }
        }
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    protected boolean addCreateElementActionIfNotExist(String elementTag, String label, Element parent, Node relativeNode) {
        Element listNode;
        XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.input;
        ArrayList<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
        String reuseType = null;
        if (elementTag.equals("restriction")) {
            Element unionNode;
            listNode = this.getFirstChildNodeIfExists(parent, "list", false);
            if (listNode != null) {
                reuseType = listNode.getAttribute("itemType");
                XSDDOMHelper.removeNodeAndWhitespace(listNode);
            }
            if ((unionNode = this.getFirstChildNodeIfExists(parent, "union", false)) != null) {
                String memberAttr = unionNode.getAttribute("memberTypes");
                if (memberAttr != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(memberAttr);
                    reuseType = stringTokenizer.nextToken();
                }
                XSDDOMHelper.removeNodeAndWhitespace(unionNode);
            }
            if (reuseType == null) {
                reuseType = this.getBuiltInStringQName();
            }
            attributes.add(new DOMAttribute("base", reuseType));
            st.setItemTypeDefinition(null);
        } else if (elementTag.equals("list")) {
            Element unionNode;
            Element restrictionNode = this.getFirstChildNodeIfExists(parent, "restriction", false);
            if (restrictionNode != null) {
                reuseType = restrictionNode.getAttribute("base");
                XSDDOMHelper.removeNodeAndWhitespace(restrictionNode);
            }
            if ((unionNode = this.getFirstChildNodeIfExists(parent, "union", false)) != null) {
                String memberAttr = unionNode.getAttribute("memberTypes");
                if (memberAttr != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(memberAttr);
                    reuseType = stringTokenizer.nextToken();
                }
                XSDDOMHelper.removeNodeAndWhitespace(unionNode);
            }
            attributes.add(new DOMAttribute("itemType", reuseType));
        } else if (elementTag.equals("union")) {
            Element restrictionNode;
            listNode = this.getFirstChildNodeIfExists(parent, "list", false);
            if (listNode != null) {
                reuseType = listNode.getAttribute("itemType");
                XSDDOMHelper.removeNodeAndWhitespace(listNode);
            }
            if ((restrictionNode = this.getFirstChildNodeIfExists(parent, "restriction", false)) != null) {
                reuseType = restrictionNode.getAttribute("base");
                XSDDOMHelper.removeNodeAndWhitespace(restrictionNode);
            }
            attributes.add(new DOMAttribute("memberTypes", reuseType));
            st.setItemTypeDefinition(null);
        }
        if (this.getFirstChildNodeIfExists(parent, elementTag, false) == null) {
            Action action = this.addCreateElementAction(elementTag, label, attributes, parent, relativeNode);
            action.run();
        }
        st.setElement(parent);
        st.updateElement();
        return true;
    }

    protected Action addCreateElementAction(String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateElementAction action = new CreateElementAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        return action;
    }

    protected Element getFirstChildNodeIfExists(Node parent, String elementTag, boolean isRef) {
        NodeList children = parent.getChildNodes();
        Element targetNode = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child instanceof Element && XSDDOMHelper.inputEquals(child, elementTag, isRef)) {
                targetNode = (Element)child;
                break;
            }
            ++i;
        }
        return targetNode;
    }

    protected String getBuiltInStringQName() {
        String prefix;
        String schemaForSchemaPrefix;
        String stringName = "string";
        if (this.xsdSchema != null && (schemaForSchemaPrefix = this.xsdSchema.getSchemaForSchemaQNamePrefix()) != null && schemaForSchemaPrefix.length() > 0 && (prefix = this.xsdSchema.getSchemaForSchemaQNamePrefix()) != null && prefix.length() > 0) {
            stringName = String.valueOf(prefix) + ":" + stringName;
        }
        return stringName;
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText) {
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(org.eclipse.wst.xsd.ui.internal.common.util.Messages._UI_ACTION_RENAME, namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(org.eclipse.wst.xsd.ui.internal.common.util.Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    private void fillTypesCombo() {
        String currentTypeName;
        ComponentSpecification ret;
        this.typesCombo.removeAll();
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
        ComponentSpecification[] items = manager.getQuickPicks();
        this.typesCombo.add(Messages._UI_ACTION_BROWSE);
        this.typesCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
        int i = 0;
        while (i < items.length) {
            this.typesCombo.add(items[i].getName());
            ++i;
        }
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.input;
        XSDTypeDefinition baseType = simpleType.getBaseType();
        if (baseType != null && baseType.getQName() != null && (ret = this.getComponentSpecFromQuickPickForValue(currentTypeName = baseType.getQName((XSDConcreteComponent)this.xsdSchema), manager)) == null && currentTypeName != null) {
            this.typesCombo.add(currentTypeName);
        }
    }

    private ComponentSpecification getComponentSpecFromQuickPickForValue(String value, ComponentReferenceEditManager editManager) {
        ComponentSpecification[] quickPicks;
        if (editManager != null && (quickPicks = editManager.getQuickPicks()) != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                if (value != null && value.equals(componentSpecification.getName())) {
                    return componentSpecification;
                }
                ++i;
            }
        }
        return null;
    }
}

