/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class EARVirtualRootFolder
extends VirtualFolder {
    public static String[] EXTENSIONS_TO_IGNORE = new String[]{".jar", ".zip", ".rar", ".war"};

    public EARVirtualRootFolder(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    public IVirtualResource[] members(int memberFlags) throws CoreException {
        IVirtualResource[] members = super.members(memberFlags);
        ArrayList<IVirtualResource> virtualResources = new ArrayList<IVirtualResource>();
        boolean shouldAdd = true;
        int i = 0;
        while (i < members.length) {
            shouldAdd = true;
            if (16 == members[i].getType()) {
                String archiveName = members[i].getName();
                int j = 0;
                while (j < EXTENSIONS_TO_IGNORE.length && shouldAdd) {
                    if (J2EEComponentClasspathUpdater.endsWithIgnoreCase(archiveName, EXTENSIONS_TO_IGNORE[j])) {
                        shouldAdd = false;
                    }
                    ++j;
                }
            }
            if (shouldAdd) {
                virtualResources.add(members[i]);
            }
            ++i;
        }
        return virtualResources.toArray(new IVirtualResource[virtualResources.size()]);
    }
}

