/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;

public class JDTTestEnvironment {
    private final ProjectTestEnvironment _projectTestEnvironment;

    public JDTTestEnvironment(ProjectTestEnvironment projectTestEnvironment) throws CoreException {
        this._projectTestEnvironment = projectTestEnvironment;
        IProject project = this._projectTestEnvironment.getTestProject();
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> preservedEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (!entry.getPath().equals((Object)project.getFullPath())) {
                preservedEntries.add(entry);
            }
            ++i;
        }
        javaProject.setRawClasspath(preservedEntries.toArray(new IClasspathEntry[0]), (IProgressMonitor)new NullProgressMonitor());
    }

    public ProjectTestEnvironment getProjectEnvironment() {
        return this._projectTestEnvironment;
    }

    public IFolder getSourceFolder(String name) throws CoreException {
        IProject project = this._projectTestEnvironment.getTestProject();
        IFolder folder = project.getFolder(name);
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            IPath path = project.getFullPath().append("bin");
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)folder.getFullPath(), (IPath[])new IPath[]{path}, (IPath)path);
            this.addClasspathEntry(entry);
        }
        return folder;
    }

    public void addClasspathEntry(IClasspathEntry newEntry) {
        try {
            IClasspathEntry[] entries = this.getJavaProject().getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[entries.length] = newEntry;
            this.getJavaProject().setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
    }

    public IPackageFragmentRoot getPackageFragmentRoot(String folderName) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this._projectTestEnvironment.getTestProject());
        IFolder folder = this.getSourceFolder(folderName);
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)folder);
        return root;
    }

    public ICompilationUnit addSourceFile(String folder, String packageName, String className, String contents) throws CoreException, JavaModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(folder);
        IPackageFragment packageFrag = root.getPackageFragment(packageName);
        if (!packageFrag.exists()) {
            packageFrag = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
        }
        ICompilationUnit newCompUnit = packageFrag.createCompilationUnit(String.valueOf(className) + ".java", contents, true, (IProgressMonitor)new NullProgressMonitor());
        return newCompUnit;
    }

    public IFile addResourceFile(String folderName, InputStream src, String path, String fileName) throws CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(folderName);
        IPackageFragment packageFrag = root.getPackageFragment(path);
        if (!packageFrag.exists()) {
            packageFrag = root.createPackageFragment(path, true, (IProgressMonitor)new NullProgressMonitor());
            packageFrag.open(null);
        }
        IFolder folder = (IFolder)packageFrag.getUnderlyingResource();
        IFile file = folder.getFile((IPath)new Path(fileName));
        file.create(src, true, null);
        return file;
    }

    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this._projectTestEnvironment.getTestProject());
    }
}

