/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.internal.provisional.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.internal.provisional.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.types.CompositeType;
import org.eclipse.jst.jsf.core.internal.types.TypeComparator;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidationMessage;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.ValidationMessageFactory;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPSemanticsValidator
extends JSPValidator
implements ISourceValidator {
    static final boolean DEBUG;
    private IDocument fDocument;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsf.validation.internal.el/debug/jspsemanticsvalidator");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile file, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 168->172)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        IStructuredDocument sDoc;
        IStructuredDocumentRegion[] regions;
        if (DEBUG) {
            System.out.println("exec JSPSemanticsValidator.validateRegion");
        }
        if (this.fDocument instanceof IStructuredDocument && (regions = (sDoc = (IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength())) != null) {
            this.validateTag((ITextRegionCollection)regions[0], reporter, this.getFile(helper), true);
        }
    }

    private IFile getFile(IValidationContext helper) {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            return wsRoot.getFile((IPath)new Path(uris[0]));
        }
        return null;
    }

    private void validateTag(ITextRegionCollection container, IReporter reporter, IFile file, boolean isIncremental) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        String uri = null;
        String tagName = null;
        String attrName = null;
        while (regions.hasNext() && !reporter.isCancelled()) {
            String attributeVal;
            region = (ITextRegion)regions.next();
            String type = region.getType();
            IDOMContextResolver resolver = null;
            ITaglibContextResolver tagLibResolver = null;
            if (type == null || type != "XML_TAG_NAME" && type != "XML_TAG_ATTRIBUTE_NAME" && type != "XML_TAG_ATTRIBUTE_VALUE") continue;
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)((IStructuredDocumentRegion)containerRegion).getParentDocument(), containerRegion.getStartOffset() + region.getStart());
            resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
            if (type == "XML_TAG_NAME") {
                tagLibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
                tagName = resolver.getNode().getLocalName();
                uri = tagLibResolver.getTagURIForNodeName(resolver.getNode());
                if (!DEBUG) continue;
                System.out.println(String.valueOf(this.addDebugSpacer(1)) + "tagName= " + (tagName != null ? tagName : "null") + ": uri= " + (uri != null ? uri : "null"));
                continue;
            }
            if (type == "XML_TAG_ATTRIBUTE_NAME") {
                attrName = resolver.getNode().getNodeName();
                if (DEBUG) {
                    System.out.println(String.valueOf(this.addDebugSpacer(2)) + "attrName= " + (attrName != null ? attrName : "null"));
                }
                if (uri == null) continue;
                continue;
            }
            if (type != "XML_TAG_ATTRIBUTE_VALUE" || this.checkIfELAndValidate(region, context, uri, tagName, attrName, attributeVal = resolver.getNode().getNodeValue(), isIncremental, reporter, file)) continue;
            if (DEBUG) {
                System.out.println(String.valueOf(this.addDebugSpacer(3)) + "attrVal= " + (attributeVal != null ? attributeVal : "null"));
            }
            if (uri == null || tagName == null || attrName == null) continue;
            this.validateAttributeValue(context, uri, tagName, attrName, attributeVal, reporter, file);
        }
    }

    private boolean checkIfELAndValidate(ITextRegion region, IStructuredDocumentContext context, String uri, String tagName, String attrName, String attrValue, boolean isIncremental, IReporter reporter, IFile file) {
        ITextRegionList regionList;
        ITextRegionCollection parentRegion;
        if (region instanceof ITextRegionCollection && (parentRegion = (ITextRegionCollection)region).getType() == "XML_TAG_ATTRIBUTE_VALUE" && (regionList = parentRegion.getRegions()).size() >= 4) {
            ITextRegion openQuote = regionList.get(0);
            ITextRegion openVBLQuote = regionList.get(1);
            if ((openQuote.getType() == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || openQuote.getType() == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE") && openVBLQuote.getType() == "JSP_VBL_OPEN") {
                ITextRegion content = regionList.get(2);
                if (content.getType() == "JSP_VBL_CONTENT") {
                    int contentStart = parentRegion.getStartOffset(content);
                    IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), contentStart);
                    String elText = parentRegion.getText(content);
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(3)) + "EL attrVal= " + elText);
                    }
                    if (this.checkShouldValidateEL(isIncremental)) {
                        MetaDataEnabledProcessingFactory metaDataEnabledProcessingFactory = MetaDataEnabledProcessingFactory.getInstance();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidELValues");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        List elVals = metaDataEnabledProcessingFactory.getAttributeValueRuntimeTypeFeatureProcessors(clazz, elContext, uri, tagName, attrName);
                        this.validateELExpression(context, elContext, elVals, attrValue, elText, reporter, file);
                    }
                } else if (content.getType() == "JSP_VBL_CLOSE") {
                    int offset = parentRegion.getStartOffset(openVBLQuote) + 1;
                    Message message = ValidationMessageFactory.create_EMPTY_EL_EXPRESSION(offset, 2, file);
                    reporter.addMessage((IValidator)this, (IMessage)message);
                }
                boolean foundClosingQuote = false;
                int i = 2;
                while (!foundClosingQuote && i < regionList.size()) {
                    ITextRegion searchRegion = regionList.get(i);
                    if (searchRegion.getType() == "JSP_VBL_CLOSE") {
                        foundClosingQuote = true;
                    }
                    ++i;
                }
                if (!foundClosingQuote) {
                    int offset = context.getDocumentPosition() + 1;
                    int length = parentRegion.getText().length();
                    Message message = ValidationMessageFactory.create_MISSING_CLOSING_EXPR_BRACKET(offset, length, file);
                    reporter.addMessage((IValidator)this, (IMessage)message);
                }
                return true;
            }
        }
        return false;
    }

    private void validateELExpression(IStructuredDocumentContext context, IStructuredDocumentContext elContext, List elVals, String attributeVal, String elText, IReporter reporter, IFile file) {
        ELExpressionValidator elValidator = new ELExpressionValidator(elContext, elText, file);
        elValidator.validateXMLNode();
        elValidator.reportFindings((IValidator)this, reporter);
        CompositeType exprType = elValidator.getExpressionType();
        if (exprType != null) {
            Iterator it = elVals.iterator();
            while (it.hasNext()) {
                IValidELValues elval = (IValidELValues)it.next();
                IMessage message = null;
                try {
                    Diagnostic status;
                    CompositeType expectedType = elval.getExpectedRuntimeType();
                    if (expectedType != null && (status = TypeComparator.calculateTypeCompatibility((CompositeType)expectedType, (CompositeType)exprType)).getSeverity() != 0) {
                        message = this.createValidationMessage(context, attributeVal, this.getSeverity(status.getSeverity()), status.getMessage(), file);
                    }
                }
                catch (ELIsNotValidException e) {
                    message = this.createValidationMessage(context, attributeVal, 2, e.getMessage(), file);
                }
                if (message == null) continue;
                reporter.addMessage((IValidator)this, message);
            }
        }
    }

    private void validateAttributeValue(IStructuredDocumentContext context, String uri, String tagName, String attrName, String attributeVal, IReporter reporter, IFile file) {
        List vv;
        MetaDataEnabledProcessingFactory metaDataEnabledProcessingFactory = MetaDataEnabledProcessingFactory.getInstance();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidValues");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(vv = metaDataEnabledProcessingFactory.getAttributeValueRuntimeTypeFeatureProcessors(clazz, context, uri, tagName, attrName)).isEmpty()) {
            Iterator it = vv.iterator();
            while (it.hasNext()) {
                IValidValues v = (IValidValues)it.next();
                if (!v.isValidValue(attributeVal.trim())) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NOT VALID ");
                    }
                    Iterator msgs = v.getValidationMessages().iterator();
                    while (msgs.hasNext()) {
                        IValidationMessage msg = (IValidationMessage)msgs.next();
                        IMessage message = this.createValidationMessage(context, attributeVal, this.getSeverity(msg.getSeverity()), msg.getMessage(), file);
                        if (message == null) continue;
                        reporter.addMessage((IValidator)this, message);
                    }
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println(String.valueOf(this.addDebugSpacer(5)) + "VALID ");
            }
        } else if (DEBUG) {
            System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NO META DATA ");
        }
    }

    private IMessage createValidationMessage(IStructuredDocumentContext context, String attributeValue, int severity, String msg, IFile file) {
        JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, severity, msg, (IResource)file);
        if (message != null) {
            int start = context.getDocumentPosition() + 1;
            int length = attributeValue.length();
            int lineNo = 0;
            try {
                lineNo = context.getStructuredDocument().getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
            message.setLineNo(lineNo);
            message.setOffset(start);
            message.setLength(length);
        }
        return message;
    }

    private int getSeverity(int severity) {
        switch (severity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 2;
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
    }

    private String addDebugSpacer(int count) {
        String TAB = "\t";
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        while (i <= count) {
            ret.append(TAB);
            ++i;
        }
        return ret.toString();
    }

    private boolean checkShouldValidateEL(boolean isIncremental) {
        ValidationPreferences prefs = new ValidationPreferences();
        prefs.load();
        if (isIncremental) {
            return prefs.getElPrefs().isEnableIncrementalValidation();
        }
        return prefs.getElPrefs().isEnableBuildValidation();
    }
}

