/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.structureddocument.internal.provisional.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.internal.provisional.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.ValidationMessageFactory;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPELValidatorCopy
extends JSPValidator {
    protected void validateRegionContainer(IStructuredDocument structuredDoc, ITextRegionCollection container, IReporter reporter, IFile file) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        while (regions.hasNext() && !reporter.isCancelled()) {
            ITextRegionList regionList;
            ITextRegionCollection parentRegion;
            region = (ITextRegion)regions.next();
            if (!(region instanceof ITextRegionCollection) || (parentRegion = (ITextRegionCollection)region).getType() != "XML_TAG_ATTRIBUTE_VALUE" || (regionList = parentRegion.getRegions()).size() < 4) continue;
            ITextRegion openQuote = regionList.get(0);
            ITextRegion openVBLQuote = regionList.get(1);
            if (openQuote.getType() != "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" && openQuote.getType() != "XML_TAG_ATTRIBUTE_VALUE_SQUOTE" || openVBLQuote.getType() != "JSP_VBL_OPEN") continue;
            ITextRegion content = regionList.get(2);
            if (content.getType() == "JSP_VBL_CONTENT") {
                int contentStart = parentRegion.getStartOffset(content);
                IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)structuredDoc, contentStart);
                ELExpressionValidator validator = new ELExpressionValidator(context, parentRegion.getText(content), file);
                validator.validateXMLNode();
                validator.reportFindings((IValidator)this, reporter);
            }
            boolean foundClosingQuote = false;
            int i = 2;
            while (i < regionList.size()) {
                ITextRegion searchRegion = regionList.get(i);
                if (searchRegion.getType() == "JSP_VBL_CLOSE") {
                    foundClosingQuote = true;
                }
                ++i;
            }
            if (foundClosingQuote) continue;
            int problemStartOffset = parentRegion.getStartOffset();
            int length = parentRegion.getLength();
            Message message = ValidationMessageFactory.create_MISSING_CLOSING_EXPR_BRACKET(problemStartOffset, length, file);
            reporter.addMessage((IValidator)this, (IMessage)message);
        }
    }

    public void validateFile(IFile file, IReporter reporter) {
    }
}

