/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.operators.EmptyUnaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.MinusUnaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.NotUnaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;

public abstract class UnaryOperator {
    public static boolean isUnaryOperator(Token token) {
        return token.kind == 33 || token.kind == 39 || token.kind == 40 || token.kind == 45;
    }

    public static UnaryOperator createUnaryOperator(Token token) {
        if (!UnaryOperator.isUnaryOperator(token)) {
            throw new IllegalArgumentException("token must be a unary operator");
        }
        switch (token.kind) {
            case 33: {
                return new MinusUnaryOperator();
            }
            case 39: 
            case 40: {
                return new NotUnaryOperator();
            }
            case 45: {
                return new EmptyUnaryOperator();
            }
        }
        throw new AssertionError();
    }

    UnaryOperator() {
    }

    public abstract ValueType performOperation(ValueType var1);

    public abstract Diagnostic validate(ValueType var1);
}

