/*******************************************************************************
 * Copyright (c) 2006 Oracle Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Cameron Bateman/Oracle - initial API and implementation
 *    
 ********************************************************************************/
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IDescribedInDetail;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ITypeDescriptor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>IBean Instance Symbol</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IBeanInstanceSymbolImpl#getJavaElement <em>Java Element</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IBeanInstanceSymbolImpl#getJavaTypeDescriptor <em>Java Type Descriptor</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IBeanInstanceSymbolImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.context.symbol.internal.impl.IBeanInstanceSymbolImpl#getMethods <em>Methods</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IBeanInstanceSymbolImpl extends IInstanceSymbolImpl implements IBeanInstanceSymbol {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright 2006 Oracle";

    /**
     * The default value of the '{@link #getJavaElement() <em>Java Element</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getJavaElement()
     * @generated
     * @ordered
     */
	protected static final IJavaElement JAVA_ELEMENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getJavaElement() <em>Java Element</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getJavaElement()
     * @generated
     * @ordered
     */
	protected IJavaElement javaElement = JAVA_ELEMENT_EDEFAULT;

    /**
     * The cached value of the '{@link #getJavaTypeDescriptor() <em>Java Type Descriptor</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getJavaTypeDescriptor()
     * @generated
     * @ordered
     */
	protected IJavaTypeDescriptor2 javaTypeDescriptor = null;

	/**
	 * A detailed description (human readable) about this instance symbol
	 */
	protected String			  detailedDescription = null;
	
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IBeanInstanceSymbolImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * @return the EClass
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass() {
        return SymbolPackage.Literals.IBEAN_INSTANCE_SYMBOL;
    }

    /**
     * <!-- begin-user-doc -->
     * @return the jdt java element for this bean instance 
	 * <!-- end-user-doc -->
     * @generated
     */
	public IJavaElement getJavaElement() {
        return javaElement;
    }

    /**
     * <!-- begin-user-doc -->
     * @param newJavaElement 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setJavaElement(IJavaElement newJavaElement) {
        IJavaElement oldJavaElement = javaElement;
        javaElement = newJavaElement;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT, oldJavaElement, javaElement));
    }

    /**
     * <!-- begin-user-doc -->
     * @return the type descriptor
	 * <!-- end-user-doc -->
     * @generated
     */
	public IJavaTypeDescriptor2 getJavaTypeDescriptor() {
        if (javaTypeDescriptor != null && javaTypeDescriptor.eIsProxy()) {
            InternalEObject oldJavaTypeDescriptor = (InternalEObject)javaTypeDescriptor;
            javaTypeDescriptor = (IJavaTypeDescriptor2)eResolveProxy(oldJavaTypeDescriptor);
            if (javaTypeDescriptor != oldJavaTypeDescriptor) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_TYPE_DESCRIPTOR, oldJavaTypeDescriptor, javaTypeDescriptor));
            }
        }
        return javaTypeDescriptor;
    }

    /**
     * <!-- begin-user-doc -->
	 * @return the java type for this bean instance
	 * <!-- end-user-doc -->
     * @generated
     */
	public IJavaTypeDescriptor2 basicGetJavaTypeDescriptor() {
        return javaTypeDescriptor;
    }

    /**
     * <!-- begin-user-doc -->
     * @param newJavaTypeDescriptor 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setJavaTypeDescriptor(IJavaTypeDescriptor2 newJavaTypeDescriptor) {
        IJavaTypeDescriptor2 oldJavaTypeDescriptor = javaTypeDescriptor;
        javaTypeDescriptor = newJavaTypeDescriptor;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_TYPE_DESCRIPTOR, oldJavaTypeDescriptor, javaTypeDescriptor));
    }

	/**
	 * <!-- begin-user-doc -->
     * @return the list of bean properties 
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getProperties() 
	{
		return getJavaTypeDescriptor().getBeanProperties();
	}

	/**
	 * <!-- begin-user-doc -->
     * @return the list of methods 
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getMethods() {
		return getJavaTypeDescriptor().getBeanMethods();
	}

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
     * @param resolve 
     * @param coreType 
     * @return the object related to featureID
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT:
                return getJavaElement();
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_TYPE_DESCRIPTOR:
                if (resolve) return getJavaTypeDescriptor();
                return basicGetJavaTypeDescriptor();
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__PROPERTIES:
                return getProperties();
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__METHODS:
                return getMethods();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
     * @param newValue 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT:
                setJavaElement((IJavaElement)newValue);
                return;
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_TYPE_DESCRIPTOR:
                setJavaTypeDescriptor((IJavaTypeDescriptor2)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(int featureID) {
        switch (featureID) {
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT:
                setJavaElement(JAVA_ELEMENT_EDEFAULT);
                return;
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_TYPE_DESCRIPTOR:
                setJavaTypeDescriptor((IJavaTypeDescriptor2)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * @param featureID 
     * @return whether the corresponding feature is set 
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT:
                return JAVA_ELEMENT_EDEFAULT == null ? javaElement != null : !JAVA_ELEMENT_EDEFAULT.equals(javaElement);
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_TYPE_DESCRIPTOR:
                return javaTypeDescriptor != null;
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__PROPERTIES:
                return !getProperties().isEmpty();
            case SymbolPackage.IBEAN_INSTANCE_SYMBOL__METHODS:
                return !getMethods().isEmpty();
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * @param derivedFeatureID 
     * @param baseClass 
     * @return the feature id for the derived feature 
	 * <!-- end-user-doc -->
     * @generated
     */
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
        if (baseClass == IJavaSymbol.class) {
            switch (derivedFeatureID) {
                case SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT: return SymbolPackage.IJAVA_SYMBOL__JAVA_ELEMENT;
                default: return -1;
            }
        }
        if (baseClass == IDescribedInDetail.class) {
            switch (derivedFeatureID) {
                default: return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * @param baseFeatureID 
     * @param baseClass 
     * @return the derived feature id 
	 * <!-- end-user-doc -->
     * @generated
     */
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == IJavaSymbol.class) {
            switch (baseFeatureID) {
                case SymbolPackage.IJAVA_SYMBOL__JAVA_ELEMENT: return SymbolPackage.IBEAN_INSTANCE_SYMBOL__JAVA_ELEMENT;
                default: return -1;
            }
        }
        if (baseClass == IDescribedInDetail.class) {
            switch (baseFeatureID) {
                default: return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * @return the derived string representation 
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (javaElement: ");
        result.append(javaElement);
        result.append(')');
        return result.toString();
    }

	public String getDetailedDescription() 
	{
		return detailedDescription;
	}

	public void setDetailedDescription(String detailedDescription) 
	{
		this.detailedDescription = detailedDescription;
	}

	/**
	 * @see org.eclipse.jst.jsf.context.symbol.internal.impl.IInstanceSymbolImpl#isTypeResolved()
	 * @generated NOT
	 */
	// @Override
	public boolean isTypeResolved() 
	{
		return getJavaTypeDescriptor() != null;
	}

    // TODO: should these methods be abstract in IInstanceSymbol?
    /**
     * @see org.eclipse.jst.jsf.context.symbol.internal.impl.IInstanceSymbolImpl#getTypeDescriptor()
     * @generated NOT
     */
    public ITypeDescriptor getTypeDescriptor() 
    {
       return getJavaTypeDescriptor();
    }

    /**
     * @see org.eclipse.jst.jsf.context.symbol.internal.impl.IInstanceSymbolImpl#setTypeDescriptor(org.eclipse.jst.jsf.context.symbol.internal.provisional.ITypeDescriptor)
     * @generated NOT
     */
    public void setTypeDescriptor(ITypeDescriptor newTypeDescriptor) 
    {
        if (newTypeDescriptor instanceof IJavaTypeDescriptor2)
        {
            setJavaTypeDescriptor((IJavaTypeDescriptor2) newTypeDescriptor);
        }
    }

    public boolean isReadable() 
    {
        // beans always readable
        return true;
    }

    public boolean isWritable() 
    {
        // beans not writable
        return false;
    }

    public void setReadable(boolean value) {
        // do nothing
    }

    public void setWritable(boolean value) {
        // do nothing
    }
    
    
} //IBeanInstanceSymbolImpl
