/*******************************************************************************
 * Copyright (c) 2006 Oracle Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Cameron Bateman/Oracle - initial API and implementation
 *    
 ********************************************************************************/
package org.eclipse.jst.jsf.context.symbol.internal.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.provider.IContentProposalProvider;
import org.eclipse.jst.jsf.context.symbol.internal.util.SymbolAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SymbolItemProviderAdapterFactory extends SymbolAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright 2006 Oracle";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * TODO: try to got to Gen function to add custom adapters
	 * instead of a NOT
	 * @generated NOT
	 */
	public SymbolItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IContentProposalProvider.class);
	}

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanInstanceSymbol} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IBeanInstanceSymbolItemProvider iBeanInstanceSymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanInstanceSymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIBeanInstanceSymbolAdapter() {
        if (iBeanInstanceSymbolItemProvider == null) {
            iBeanInstanceSymbolItemProvider = new IBeanInstanceSymbolItemProvider(this);
        }

        return iBeanInstanceSymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanPropertySymbol} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IBeanPropertySymbolItemProvider iBeanPropertySymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanPropertySymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIBeanPropertySymbolAdapter() {
        if (iBeanPropertySymbolItemProvider == null) {
            iBeanPropertySymbolItemProvider = new IBeanPropertySymbolItemProvider(this);
        }

        return iBeanPropertySymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IInstanceSymbol} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IInstanceSymbolItemProvider iInstanceSymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IInstanceSymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIInstanceSymbolAdapter() {
        if (iInstanceSymbolItemProvider == null) {
            iInstanceSymbolItemProvider = new IInstanceSymbolItemProvider(this);
        }

        return iInstanceSymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaSymbol} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IJavaSymbolItemProvider iJavaSymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaSymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIJavaSymbolAdapter() {
        if (iJavaSymbolItemProvider == null) {
            iJavaSymbolItemProvider = new IJavaSymbolItemProvider(this);
        }

        return iJavaSymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaTypeDescriptor2} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IJavaTypeDescriptor2ItemProvider iJavaTypeDescriptor2ItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IJavaTypeDescriptor2}.
     * <!-- begin-user-doc -->
     * @return the adapter 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIJavaTypeDescriptor2Adapter() {
        if (iJavaTypeDescriptor2ItemProvider == null) {
            iJavaTypeDescriptor2ItemProvider = new IJavaTypeDescriptor2ItemProvider(this);
        }

        return iJavaTypeDescriptor2ItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanMethodSymbol} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IBeanMethodSymbolItemProvider iBeanMethodSymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IBeanMethodSymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIBeanMethodSymbolAdapter() {
        if (iBeanMethodSymbolItemProvider == null) {
            iBeanMethodSymbolItemProvider = new IBeanMethodSymbolItemProvider(this);
        }

        return iBeanMethodSymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IComponentSymbol} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IComponentSymbolItemProvider iComponentSymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IComponentSymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter 
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createIComponentSymbolAdapter() {
        if (iComponentSymbolItemProvider == null) {
            iComponentSymbolItemProvider = new IComponentSymbolItemProvider(this);
        }

        return iComponentSymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IPropertySymbol} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IPropertySymbolItemProvider iPropertySymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IPropertySymbol}.
     * <!-- begin-user-doc -->
     * @return the property symbol adapter 
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createIPropertySymbolAdapter() {
        if (iPropertySymbolItemProvider == null) {
            iPropertySymbolItemProvider = new IPropertySymbolItemProvider(this);
        }

        return iPropertySymbolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IMapTypeDescriptor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IMapTypeDescriptorItemProvider iMapTypeDescriptorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IMapTypeDescriptor}.
     * <!-- begin-user-doc -->
     * @return the adapter 
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createIMapTypeDescriptorAdapter() {
        if (iMapTypeDescriptorItemProvider == null) {
            iMapTypeDescriptorItemProvider = new IMapTypeDescriptorItemProvider(this);
        }

        return iMapTypeDescriptorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IMethodSymbol} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IMethodSymbolItemProvider iMethodSymbolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.context.symbol.internal.provisional.IMethodSymbol}.
     * <!-- begin-user-doc -->
     * @return the adapter for method symbols 
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createIMethodSymbolAdapter() {
        if (iMethodSymbolItemProvider == null) {
            iMethodSymbolItemProvider = new IMethodSymbolItemProvider(this);
        }

        return iMethodSymbolItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * @return the adapter factory
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * @param parentAdapterFactory 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * @param type 
     * @return true if the factory supports the adapter type 
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * @param notifier 
     * @param type 
     * @return the adapter
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
     * @param object 
     * @param type 
     * @return the adapted object 
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * @param notifyChangedListener 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * @param notifyChangedListener 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * @param notification 
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (iBeanInstanceSymbolItemProvider != null) iBeanInstanceSymbolItemProvider.dispose();
        if (iBeanPropertySymbolItemProvider != null) iBeanPropertySymbolItemProvider.dispose();
        if (iInstanceSymbolItemProvider != null) iInstanceSymbolItemProvider.dispose();
        if (iJavaSymbolItemProvider != null) iJavaSymbolItemProvider.dispose();
        if (iJavaTypeDescriptor2ItemProvider != null) iJavaTypeDescriptor2ItemProvider.dispose();
        if (iBeanMethodSymbolItemProvider != null) iBeanMethodSymbolItemProvider.dispose();
        if (iComponentSymbolItemProvider != null) iComponentSymbolItemProvider.dispose();
        if (iPropertySymbolItemProvider != null) iPropertySymbolItemProvider.dispose();
        if (iMapTypeDescriptorItemProvider != null) iMapTypeDescriptorItemProvider.dispose();
        if (iMethodSymbolItemProvider != null) iMethodSymbolItemProvider.dispose();
    }

}
