/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DependencyGraphManager {
    private static DependencyGraphManager INSTANCE = null;
    private static final String MANIFEST_URI = "META-INF/MANIFEST.MF";
    private HashMap wtpModuleTimeStamps = null;
    private HashMap manifestTimeStamps = null;

    private DependencyGraphManager() {
    }

    public static final synchronized DependencyGraphManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DependencyGraphManager();
        }
        return INSTANCE;
    }

    public void construct(IProject project) {
        if (project != null && project.isAccessible() && project.findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH) != null) {
            this.constructIfNecessary();
        }
    }

    private void constructIfNecessary() {
        if (this.moduleTimeStampsChanged() || this.manifestTimeStampsChanged()) {
            this.buildDependencyGraph();
        }
    }

    private boolean manifestTimeStampsChanged() {
        HashMap workspaceTimeStamps = this.collectManifestTimeStamps();
        return !this.getManifestTimeStamps().equals(workspaceTimeStamps);
    }

    private HashMap getManifestTimeStamps() {
        if (this.wtpModuleTimeStamps == null) {
            this.wtpModuleTimeStamps = new HashMap();
        }
        return this.wtpModuleTimeStamps;
    }

    private HashMap collectManifestTimeStamps() {
        HashMap<IProject, Long> timeStamps = new HashMap<IProject, Long>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IFile manifestFile = null;
            if (projects[i] != null && projects[i].isAccessible() && (manifestFile = this.getTimeStampFile(projects[i])) != null) {
                Long currentTimeStamp = new Long(manifestFile.getLocalTimeStamp());
                timeStamps.put(projects[i], currentTimeStamp);
            }
            ++i;
        }
        return timeStamps;
    }

    private IFile getTimeStampFile(IProject p) {
        IVirtualComponent component = ComponentCore.createComponent(p);
        if (component == null) {
            return null;
        }
        if (component.isBinary()) {
            return ((VirtualArchiveComponent)component).getUnderlyingWorkbenchFile();
        }
        try {
            IFile file = ComponentUtilities.findFile(component, (IPath)new Path(MANIFEST_URI));
            if (file != null) {
                return file;
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
        }
        return null;
    }

    private boolean moduleTimeStampsChanged() {
        HashMap workspaceTimeStamps = this.collectModuleTimeStamps();
        return !this.getWtpModuleTimeStamps().equals(workspaceTimeStamps);
    }

    private HashMap collectModuleTimeStamps() {
        HashMap<IProject, Long> timeStamps = new HashMap<IProject, Long>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IResource wtpModulesFile;
            if (projects[i] != null && projects[i].isAccessible() && (wtpModulesFile = projects[i].findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH)) != null) {
                Long currentTimeStamp = new Long(wtpModulesFile.getLocalTimeStamp());
                timeStamps.put(projects[i], currentTimeStamp);
            }
            ++i;
        }
        return timeStamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDependencyGraph() {
        ArrayList referencesToAdd = new ArrayList();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int k = 0;
        while (k < projects.length) {
            IVirtualComponent component;
            if (projects[k].isAccessible() && projects[k].findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH) != null && (component = ComponentCore.createComponent(projects[k])) != null) {
                referencesToAdd.addAll(this.getDependencyReferences(component));
            }
            ++k;
        }
        DependencyGraphManager dependencyGraphManager = this;
        synchronized (dependencyGraphManager) {
            ArrayList<IProject> timeStampsUpdated = new ArrayList<IProject>();
            this.cleanDependencyGraph();
            int i = 0;
            while (i < referencesToAdd.size()) {
                DependencyReference ref = (DependencyReference)referencesToAdd.get(i);
                if (ref.targetProject != null && ref.componentProject != null && !ref.targetProject.equals((Object)ref.componentProject)) {
                    DependencyGraph.getInstance().addReference(ref.targetProject, ref.componentProject);
                    if (!timeStampsUpdated.contains(ref.componentProject)) {
                        this.addTimeStamp(ref.componentProject);
                        timeStampsUpdated.add(ref.componentProject);
                    }
                }
                ++i;
            }
        }
    }

    private List getDependencyReferences(IVirtualComponent component) {
        ArrayList<DependencyReference> refs = new ArrayList<DependencyReference>();
        IProject componentProject = component.getProject();
        IVirtualReference[] depRefs = component.getReferences();
        int i = 0;
        while (i < depRefs.length) {
            IVirtualComponent targetComponent = depRefs[i].getReferencedComponent();
            if (targetComponent != null) {
                IProject targetProject = targetComponent.getProject();
                refs.add(new DependencyReference(targetProject, componentProject));
            }
            ++i;
        }
        return refs;
    }

    private boolean addTimeStamp(IProject project) {
        IResource wtpModulesFile = project.findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH);
        if (wtpModulesFile == null) {
            return false;
        }
        Long currentTimeStamp = new Long(wtpModulesFile.getLocalTimeStamp());
        this.getWtpModuleTimeStamps().put(project, currentTimeStamp);
        IFile manifestFile = this.getTimeStampFile(project);
        if (manifestFile == null) {
            return false;
        }
        this.getManifestTimeStamps().put(project, currentTimeStamp);
        return true;
    }

    private void cleanDependencyGraph() {
        DependencyGraph.getInstance().clear();
        this.getWtpModuleTimeStamps().clear();
        this.getManifestTimeStamps().clear();
    }

    private HashMap getWtpModuleTimeStamps() {
        if (this.wtpModuleTimeStamps == null) {
            this.wtpModuleTimeStamps = new HashMap();
        }
        return this.wtpModuleTimeStamps;
    }

    public DependencyGraph getDependencyGraph() {
        this.constructIfNecessary();
        return DependencyGraph.getInstance();
    }

    public void forceRefresh() {
        this.buildDependencyGraph();
    }

    private class DependencyReference {
        public IProject componentProject;
        public IProject targetProject;

        public DependencyReference(IProject target, IProject component) {
            this.componentProject = component;
            this.targetProject = target;
        }
    }
}

