/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.util;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.provisional.util.TypeUtil;

public class JDTBeanProperty {
    private IMethod _getter;
    private IMethod _setter;
    protected final IType _type;

    protected JDTBeanProperty(IType type) {
        this._type = type;
    }

    public boolean isReadable() {
        return this._getter != null;
    }

    public boolean isWritable() {
        return this._setter != null;
    }

    public IMethod getGetter() {
        return this._getter;
    }

    void setGetter(IMethod getter) {
        this._getter = getter;
    }

    public IMethod getSetter() {
        return this._setter;
    }

    void setSetter(IMethod setter) {
        this._setter = setter;
    }

    public IType getType() {
        String typeSignature = this.getTypeSignature();
        return TypeUtil.resolveType(this._type, typeSignature);
    }

    public String getTypeSignature() {
        try {
            String unResolvedSig = this.getUnresolvedType();
            String signature = TypeUtil.resolveTypeSignature(this._type, unResolvedSig);
            return signature;
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log((Exception)((Object)jme), "Error resolving bean property type signature");
            return null;
        }
    }

    private String getUnresolvedType() throws JavaModelException {
        String typeSig = null;
        typeSig = this._getter != null ? this._getter.getReturnType() : this._setter.getParameterTypes()[0];
        return typeSig;
    }
}

