/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.internal.jsp.JSPModelProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import plugin.Activator;

public class StartupHandler
implements IStartup {
    private final JSPEditorListener _partListener = new JSPEditorListener();

    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IEditorReference[] editorReferences = pages[j].getEditorReferences();
                        int k = 0;
                        while (k < editorReferences.length) {
                            if (StartupHandler.this._partListener.isValidJSPEditor(editorReferences[k])) {
                                StartupHandler.this._partListener.setJSPModelListener(editorReferences[k]);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    windows[i].getPartService().addPartListener((IPartListener2)StartupHandler.this._partListener);
                    ++i;
                }
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                        window.getPartService().removePartListener((IPartListener2)StartupHandler.access$0(1.access$0(this.this$1)));
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                        window.getPartService().addPartListener((IPartListener2)StartupHandler.access$0(1.access$0(this.this$1)));
                    }
                });
            }

            static /* synthetic */ StartupHandler access$0(1 var0) {
                return var0.StartupHandler.this;
            }
        });
    }

    private static class JSPEditorListener
    implements IPartListener2 {
        static /* synthetic */ Class class$0;

        private JSPEditorListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (this.isValidJSPEditor(partRef)) {
                this.releaseJSPModelListener((IEditorReference)partRef);
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            if (this.isValidJSPEditor(partRef)) {
                this.setJSPModelListener((IEditorReference)partRef);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        private boolean isJSPEditor(IEditorReference editorRef) {
            IContentTypeManager typeManager;
            IContentType jspContentType;
            IFile file = this.getIFile(editorRef);
            return file != null && (jspContentType = (typeManager = Platform.getContentTypeManager()).getContentType("org.eclipse.jst.jsp.core.jspsource")) != null && jspContentType.isAssociatedWith(file.getName());
        }

        boolean isValidJSPEditor(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            return file != null && JSFAppConfigUtils.isValidJSFProject((IProject)file.getProject()) && this.isJSPEditor(editorRef);
        }

        boolean isValidJSPEditor(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                return this.isValidJSPEditor((IEditorReference)partRef);
            }
            return false;
        }

        void setJSPModelListener(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            if (file != null) {
                try {
                    JSPModelProcessor processor = JSPModelProcessor.get(file);
                    processor.refresh(false);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.designtime", 0, "Error acquiring model processor", (Throwable)e));
                }
            }
        }

        void releaseJSPModelListener(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            if (file != null) {
                JSPModelProcessor.dispose(file);
            }
        }

        IFile getIFile(IEditorReference editorRef) {
            try {
                Object adapt;
                IEditorInput editorInput = editorRef.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapt = editorInput.getAdapter((Class)clazz)) instanceof IFile) {
                    return (IFile)adapt;
                }
            }
            catch (PartInitException excp) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.designtime", 0, "Error acquiring editor input", (Throwable)excp));
            }
            return null;
        }
    }
}

