/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure;

import java.util.Vector;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LabelAnchor;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure.NodeLabel;
import org.eclipse.jst.jsf.facesconfig.ui.preference.GEMPreferences;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class PageflowNodeFigure
extends Figure {
    protected Vector connectionAnchors = new Vector(1);
    private NodeLabel label;
    private Color labelFgColor;
    private Color labelBgColor;
    private int textPlacement = 4;

    public PageflowNodeFigure() {
        this.setLayoutManager((LayoutManager)new FlowLayout());
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        if (this.getSourceConnectionAnchors().size() == 0) {
            return null;
        }
        return (ConnectionAnchor)this.getSourceConnectionAnchors().get(0);
    }

    public ConnectionAnchor getSourceConnectionAnchor() {
        if (this.getSourceConnectionAnchors().size() == 0) {
            return null;
        }
        return (ConnectionAnchor)this.getSourceConnectionAnchors().get(0);
    }

    private Vector getSourceConnectionAnchors() {
        return this.connectionAnchors;
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        if (this.getTargetConnectionAnchors().size() == 0) {
            return null;
        }
        return (ConnectionAnchor)this.getTargetConnectionAnchors().get(0);
    }

    public ConnectionAnchor getTargetConnectionAnchor() {
        if (this.getTargetConnectionAnchors().size() == 0) {
            return null;
        }
        return (ConnectionAnchor)this.getTargetConnectionAnchors().get(0);
    }

    private Vector getTargetConnectionAnchors() {
        return this.connectionAnchors;
    }

    public void update() {
        this.initializeConnectionAnchors();
    }

    private void initializeConnectionAnchors() {
        this.connectionAnchors.removeAllElements();
        LabelAnchor inputConnectionAnchor = new LabelAnchor((Label)this.label);
        this.connectionAnchors.addElement(inputConnectionAnchor);
    }

    private int getTextPlacement() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        String s = store.getString("LabelPlacement");
        if ("Top".equals(s)) {
            this.textPlacement = 1;
        } else if ("Bottom".equals(s)) {
            this.textPlacement = 4;
        } else if ("Left".equals(s)) {
            this.textPlacement = 8;
        } else if ("Right".equals(s)) {
            this.textPlacement = 16;
        }
        return this.textPlacement;
    }

    private Color getLabelBackgroundColor() {
        return this.labelBgColor;
    }

    private Color getLabelForegroundColor() {
        if (this.labelFgColor == null) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            this.labelFgColor = GEMPreferences.getColor(store, "FigureLabelFontColor");
        }
        return this.labelFgColor;
    }

    private Font getLabelFont() {
        IPreferenceStore store;
        FontData fontData;
        FontRegistry registry = JFaceResources.getFontRegistry();
        if (!registry.get((fontData = PreferenceConverter.getFontData((IPreferenceStore)(store = EditorPlugin.getDefault().getPreferenceStore()), (String)"FigureLabelFont")).toString()).equals((Object)registry.defaultFont())) {
            return registry.get(fontData.toString());
        }
        registry.put(fontData.toString(), new FontData[]{fontData});
        return registry.get(fontData.toString());
    }

    public void setImageText(Image image, String str) {
        if (image == null) {
            this.setText(str);
        } else if (str == null) {
            this.setImage(image);
        } else if (this.label == null) {
            this.label = new NodeLabel(str, image);
            this.label.setTextPlacement(this.getTextPlacement());
            this.label.setForegroundColor(this.getLabelForegroundColor());
            this.label.setFont(this.getLabelFont());
            this.add((IFigure)this.label);
            this.initializeConnectionAnchors();
        } else {
            this.label.setIcon(image);
            this.label.setText(str);
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        if (this.label == null) {
            this.label = new NodeLabel(image);
            this.label.setTextPlacement(this.getTextPlacement());
            this.label.setForegroundColor(this.getLabelForegroundColor());
            this.label.setFont(this.getLabelFont());
            this.add((IFigure)this.label);
            this.initializeConnectionAnchors();
        } else {
            this.label.setIcon(image);
        }
    }

    public void setText(String str) {
        if (str == null) {
            return;
        }
        if (this.label == null) {
            this.label = new NodeLabel(str);
            this.label.setTextPlacement(this.getTextPlacement());
            this.label.setForegroundColor(this.getLabelForegroundColor());
            this.label.setFont(this.getLabelFont());
            this.add((IFigure)this.label);
            this.initializeConnectionAnchors();
        } else {
            this.label.setText(str);
        }
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public Rectangle getImageBounds() {
        return this.label.getIconBounds();
    }

    public Rectangle getTextBounds() {
        return this.label.getTextBounds();
    }

    public Label getLabel() {
        return this.label;
    }

    public void setBackgroundColor(Color bg) {
        this.labelBgColor = bg;
        if (this.label != null) {
            this.label.setBackgroundColor(bg);
        }
    }

    public void setForegroundColor(Color fg) {
        this.labelFgColor = fg;
        if (this.label != null) {
            this.label.setForegroundColor(fg);
        }
    }

    public void setFont(Font f) {
        if (this.label != null) {
            this.label.setFont(f);
        }
        super.setFont(f);
    }

    public void setTextPlacement(int where) {
        this.textPlacement = where;
        if (this.label != null) {
            this.label.setTextPlacement(where);
        }
    }

    public void setToolTipText(String text) {
        Label toolTip = null;
        if (text != null && text.length() > 0) {
            toolTip = new Label(text);
            toolTip.setBorder((Border)new MarginBorder(3));
        }
        super.setToolTip(toolTip);
    }

    public String getToolTipText() {
        if (this.getToolTip() != null) {
            return ((Label)this.getToolTip()).getText();
        }
        return null;
    }
}

