/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ProjectTestEnvironment {
    protected boolean _projectCreated = false;
    protected final String _projectName;
    protected IProject _project;

    public ProjectTestEnvironment(String projectName) {
        this._projectName = projectName;
    }

    public boolean isProjectCreated() {
        return this._projectCreated;
    }

    public void createProject() {
        if (!this.isProjectCreated()) {
            this.deleteProject();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this._projectName);
            if (!project.exists()) {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    project.create((IProgressMonitor)monitor);
                    project.open((IProgressMonitor)monitor);
                    this._project = project;
                    this._projectCreated = true;
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
            }
        }
    }

    public void deleteProject() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject oldWebProj = workspace.getRoot().getProject(this._projectName);
        try {
            if (oldWebProj != null && oldWebProj.isAccessible()) {
                workspace.delete(new IResource[]{oldWebProj}, true, null);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void setProjectDirtied() {
        this._projectCreated = false;
    }

    public void recreateProject() {
        this.setProjectDirtied();
        this.createProject();
    }

    public IProject getTestProject() {
        if (this._projectCreated) {
            return this._project;
        }
        return null;
    }
}

