/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.jsf.test.util.Activator;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.osgi.framework.Bundle;

public class WebProjectTestEnvironment
extends ProjectTestEnvironment {
    public WebProjectTestEnvironment(String projectName) {
        super(projectName);
    }

    public void createProject() {
        try {
            this._project = this.createWebProject(this._projectName);
            this._projectCreated = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private IProject createWebProject(String projectName) throws Exception {
        if (!this.isProjectCreated()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            dataModel.dispose();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public IVirtualContainer getWebRoot(boolean create, boolean force) {
        IVirtualFolder webRoot = ComponentCore.createComponent((IProject)this.getTestProject()).getRootFolder();
        if (!webRoot.exists() && create) {
            try {
                webRoot.create(force ? 256 : 0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                Activator.log("Error creating web root", ce);
                ce.printStackTrace();
            }
        }
        return webRoot;
    }

    public IResource loadResourceInWebRoot(Bundle bundle, String srcFileName, String destFileName) throws IOException, CoreException {
        TestFileResource resource = new TestFileResource();
        resource.load(bundle, srcFileName);
        IFile file = this.getWebRoot(true, true).getFile((IPath)new Path(destFileName)).getUnderlyingFile();
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(resource.toBytes()), true, null);
        } else {
            file.setContents((InputStream)new ByteArrayInputStream(resource.toBytes()), true, true, null);
        }
        return file;
    }
}

