/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.tests.dbdefinition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.SQLRoutinesFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class DB2iSeriesTest
extends TestCase {
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_V5R2 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_V5R2 = 18;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_V5R2 = 10;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_V5R2 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_V5R2 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_V5R2 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_V5R2 = 128;
    private final int MAXIMUM_LENGTH_BLOB_V5R2 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CLOB_V5R2 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CHAR_V5R2 = 32766;
    private final int MAXIMUM_LENGTH_DATALINK_V5R2 = 32717;
    private final int MAXIMUM_LENGTH_DBCLOB_V5R2 = 0x3FFFFFFF;
    private final int MAXIMUM_LENGTH_GRAPHIC_V5R2 = 16383;
    private final int MAXIMUM_LENGTH_VARCHAR_V5R2 = 32740;
    private final int MAXIMUM_LENGTH_VARGRAPHIC_V5R2 = 16370;
    private final int MAXIMUM_PRECISION_DECIMAL_V5R2 = 31;
    private final int MAXIMUM_PRECISION_FLOAT_V5R2 = 53;
    private final int MAXIMUM_PRECISION_NUMERIC_V5R2 = 31;
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_V5R3 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_V5R3 = 18;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_V5R3 = 10;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_V5R3 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_V5R3 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_V5R3 = 128;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_V5R3 = 128;
    private final int MAXIMUM_LENGTH_BLOB_V5R3 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CLOB_V5R3 = Integer.MAX_VALUE;
    private final int MAXIMUM_LENGTH_CHAR_V5R3 = 32766;
    private final int MAXIMUM_LENGTH_DATALINK_V5R3 = 32717;
    private final int MAXIMUM_LENGTH_DBCLOB_V5R3 = 0x3FFFFFFF;
    private final int MAXIMUM_LENGTH_GRAPHIC_V5R3 = 16383;
    private final int MAXIMUM_LENGTH_VARBINARY_V5R3 = 32740;
    private final int MAXIMUM_LENGTH_VARCHAR_V5R3 = 32740;
    private final int MAXIMUM_LENGTH_VARGRAPHIC_V5R3 = 16370;
    private final int MAXIMUM_PRECISION_DECIMAL_V5R3 = 63;
    private final int MAXIMUM_PRECISION_FLOAT_V5R3 = 53;
    private final int MAXIMUM_PRECISION_NUMERIC_V5R3 = 63;
    private final String strProduct = "DB2 UDB iSeries";
    private final String PACKAGE_NAME = "org.eclipse.wst.rdb.internal.models.dbdefinition";
    private int expectedMaxPrecision = 0;
    private int expectedMaxLength = 0;
    private int expectedIdentifierLength = 0;
    private int actualIdentifierLength = 0;
    private Iterator productVersion = null;
    private Iterator dataType;
    private List dataTypeList;
    private ArrayList definitionCollection = new ArrayList();
    private ArrayList dbInformationCollection = new ArrayList();
    private String strProductVersion = null;
    private DatabaseDefinition definition = null;
    private PredefinedDataTypeDefinition typeDefinition = null;
    private Procedure procedure = null;

    public void setUp() {
        try {
            this.productVersion = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getVersions("DB2 UDB iSeries");
            DB2iSeriesTest.assertNotNull((String)"\nMethod: getVersions()\nError: The method returns a NULL value in startUp()", (Object)this.productVersion);
            while (this.productVersion.hasNext()) {
                this.strProductVersion = this.productVersion.next().toString();
                this.definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition("DB2 UDB iSeries", this.strProductVersion);
                DB2iSeriesTest.assertNotNull((String)"\nMethod: getDefinition()\nError: The method returns a NULL value in startUp()", (Object)this.definition);
                this.dbInformationCollection.add(this.strProductVersion);
                this.definitionCollection.add(this.definition);
            }
        }
        catch (Exception e) {
            DB2iSeriesTest.fail((String)("\nMethod: setUp()\nException: " + e.toString() + "\nDescription: The set up is incomplete"));
        }
    }

    public void testGetMaximumPrecision_DECIMAL_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 31;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 31;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 53;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32766;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_GRAPHIC_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 16383;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("GRAPHIC")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "GRAPHIC"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32740;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CLOB_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CLOB")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BLOB_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BLOB")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_DATALINK_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32717;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DATALINK")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "DATALINK"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_DBCLOB_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 0x3FFFFFFF;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DBCLOB")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "DBCLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARGRAPHIC_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R2")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 16370;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARGRAPHIC")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARGRAPHIC"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 18;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 10;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 30;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_V5R2() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R2")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_DECIMAL_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 63;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 63;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 53;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CHAR_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32766;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CHAR")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_GRAPHIC_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 16383;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("GRAPHIC")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "GRAPHIC"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARCHAR_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32740;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARCHAR"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARBINARY_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32740;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARCHAR FOR BIT DATA")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARBINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_CLOB_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("CLOB")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "CLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BLOB_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = Integer.MAX_VALUE;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BLOB")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_DATALINK_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 32717;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DATALINK")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "DATALINK"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_DBCLOB_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 0x3FFFFFFF;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DBCLOB")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "DBCLOB"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARGRAPHIC_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("V5R3")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 16370;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARGRAPHIC")) {
                            DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARGRAPHIC"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 18;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 10;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 30;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_V5R3() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("V5R3")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 128;
                    DB2iSeriesTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                DB2iSeriesTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    private String getAssertionFailureMessage(String methodName, Object versionName, String dataName) {
        String temp = "\nData type: ";
        if (dataName.equals("")) {
            temp = "";
        }
        return "\nPackage: org.eclipse.wst.rdb.internal.models.dbdefinition\nMethod: " + methodName + "\nProduct: " + "DB2 UDB iSeries" + "\nVersion: " + versionName + temp + dataName + "\nResult: The actual value does not agree with vendor doc. ";
    }

    private String getExceptionMessage(String methodName, Object versionName, Exception e) {
        return "\nMethod: " + methodName + "\nProduct: " + "DB2 UDB iSeries" + "\nVersion: " + versionName + "\nException: " + e.toString() + "\nDescription: The exception is thrown in the test case";
    }

    public void tearDown() {
        this.expectedMaxPrecision = 0;
        this.expectedMaxLength = 0;
        this.expectedIdentifierLength = 0;
        this.actualIdentifierLength = 0;
        this.productVersion = null;
        this.dataType = null;
        this.dataTypeList = null;
        this.definitionCollection = new ArrayList();
        this.dbInformationCollection = new ArrayList();
        this.strProductVersion = null;
        this.definition = null;
        this.typeDefinition = null;
        this.procedure = null;
    }
}

