/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.tests.dbdefinition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.SQLRoutinesFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class SybaseTest
extends TestCase {
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_12X = 28;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_12X = 28;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_12X = 28;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_12X = 28;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_12X = 28;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_12X = 28;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_12X = 28;
    private final int MAXIMUM_LENGTH_BINARY_12X = 255;
    private final int MAXIMUM_LENGTH_VARBINARY_12X = 255;
    private final int MAXIMUM_PRECISION_DECIMAL_12X = 38;
    private final int MAXIMUM_PRECISION_FLOAT_12X = 48;
    private final int MAXIMUM_PRECISION_NUMERIC_12X = 38;
    private final int MAXIMUM_IDENTIFIER_LENGTH_COLUMN_15 = 255;
    private final int MAXIMUM_IDENTIFIER_LENGTH_DATABASE_15 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_SCHEMA_15 = 30;
    private final int MAXIMUM_IDENTIFIER_LENGTH_STORED_PROCEDURE_15 = 255;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TABLE_15 = 255;
    private final int MAXIMUM_IDENTIFIER_LENGTH_TRIGGER_15 = 255;
    private final int MAXIMUM_IDENTIFIER_LENGTH_UDT_15 = 255;
    private final int MAXIMUM_IDENTIFIER_LENGTH_VIEW_15 = 255;
    private final int MAXIMUM_LENGTH_BINARY_15 = 255;
    private final int MAXIMUM_LENGTH_VARBINARY_15 = 255;
    private final int MAXIMUM_PRECISION_DECIMAL_15 = 38;
    private final int MAXIMUM_PRECISION_FLOAT_15 = 48;
    private final int MAXIMUM_PRECISION_NUMERIC_15 = 38;
    private final String strProduct = "Sybase";
    private final String PACKAGE_NAME = "org.eclipse.wst.rdb.internal.models.dbdefinition";
    private int expectedMaxPrecision = 0;
    private int expectedMaxLength = 0;
    private int expectedIdentifierLength = 0;
    private int actualIdentifierLength = 0;
    private Iterator productVersion = null;
    private Iterator dataType;
    private List dataTypeList;
    private ArrayList definitionCollection = new ArrayList();
    private ArrayList dbInformationCollection = new ArrayList();
    private String strProductVersion = null;
    private DatabaseDefinition definition = null;
    private PredefinedDataTypeDefinition typeDefinition = null;
    private Procedure procedure = null;

    public void setUp() {
        try {
            this.productVersion = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getVersions("Sybase");
            SybaseTest.assertNotNull((String)"\nMethod: getVersions()\nError: The method returns a NULL value in startUp()", (Object)this.productVersion);
            while (this.productVersion.hasNext()) {
                this.strProductVersion = this.productVersion.next().toString();
                this.definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition("Sybase", this.strProductVersion);
                SybaseTest.assertNotNull((String)"\nMethod: getDefinition()\nError: The method returns a NULL value in startUp()", (Object)this.definition);
                this.dbInformationCollection.add(this.strProductVersion);
                this.definitionCollection.add(this.definition);
            }
        }
        catch (Exception e) {
            SybaseTest.fail((String)("\nMethod: setUp()\nException: " + e.toString() + "\nDescription: The set up is incomplete"));
        }
    }

    public void testGetMaximumPrecision_DECIMAL_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("12.x")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("12.x")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("12.x")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 48;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BINARY_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("12.x")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 255;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BINARY")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARBINARY_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("12.x")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 255;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARBINARY")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARBINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_12X() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("12.x")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 28;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(0), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_DECIMAL_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("15.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("DECIMAL")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "DECIMAL"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_NUMERIC_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("15.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 38;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("NUMERIC")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "NUMERIC"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumPrecision_FLOAT_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("15.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxPrecision = 48;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("FLOAT")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumPrecision()", this.dbInformationCollection.get(i), "FLOAT"), (int)this.expectedMaxPrecision, (int)this.typeDefinition.getMaximumPrecision());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumPrecision()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_BINARY_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("15.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 255;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("BINARY")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "BINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetMaximumLength_VARBINARY_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                this.dataType = ((DatabaseDefinition)this.definitionCollection.get(i)).getPredefinedDataTypes();
                while (this.dataType.hasNext()) {
                    this.typeDefinition = (PredefinedDataTypeDefinition)this.dataType.next();
                    if (!this.dbInformationCollection.get(i).toString().equals("15.0")) continue;
                    this.dataTypeList = this.typeDefinition.getName();
                    this.expectedMaxLength = 255;
                    int j = 0;
                    while (j < this.dataTypeList.size()) {
                        if (this.dataTypeList.get(j).equals("VARBINARY")) {
                            SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumLength()", this.dbInformationCollection.get(i), "VARBINARY"), (int)this.expectedMaxLength, (int)this.typeDefinition.getMaximumLength());
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetDatabaseMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getDatabaseMaximumIdentifierLength();
                    this.expectedIdentifierLength = 30;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getDatabaseMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetSchemaMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getSchemaMaximumIdentifierLength();
                    this.expectedIdentifierLength = 30;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getSchemaMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTableMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTableMaximumIdentifierLength();
                    this.expectedIdentifierLength = 255;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getTableMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetViewMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getViewMaximumIdentifierLength();
                    this.expectedIdentifierLength = 255;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getViewMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetColumnMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getColumnMaximumIdentifierLength();
                    this.expectedIdentifierLength = 255;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getColumnMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetUDTMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getUserDefinedTypeMaximumIdentifierLength();
                    this.expectedIdentifierLength = 255;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getUserDefinedTypeMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getUserDefinedTypeMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetTriggerMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getTriggerMaximumIdentifierLength();
                    this.expectedIdentifierLength = 255;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getTriggerMaximumIdentifierLength()", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    public void testGetStoredProcedureMaximumIdentifierLength_15() {
        int i = 0;
        while (i < this.definitionCollection.size()) {
            try {
                if (this.dbInformationCollection.get(i).toString().equals("15.0")) {
                    this.procedure = SQLRoutinesFactory.eINSTANCE.createProcedure();
                    this.actualIdentifierLength = ((DatabaseDefinition)this.definitionCollection.get(i)).getMaximumIdentifierLength((SQLObject)this.procedure);
                    this.expectedIdentifierLength = 255;
                    SybaseTest.assertEquals((String)this.getAssertionFailureMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(i), ""), (int)this.expectedIdentifierLength, (int)this.actualIdentifierLength);
                }
            }
            catch (Exception e) {
                SybaseTest.fail((String)this.getExceptionMessage("getMaximumIdentifierLength(SQLObject sqlObject)", this.dbInformationCollection.get(1), e));
            }
            ++i;
        }
    }

    private String getAssertionFailureMessage(String methodName, Object versionName, String dataName) {
        String temp = "\nData type: ";
        if (dataName.equals("")) {
            temp = "";
        }
        return "\nPackage: org.eclipse.wst.rdb.internal.models.dbdefinition\nMethod: " + methodName + "\nProduct: " + "Sybase" + "\nVersion: " + versionName + temp + dataName + "\nResult: The actual value does not agree with vendor doc. ";
    }

    private String getExceptionMessage(String methodName, Object versionName, Exception e) {
        return "\nMethod: " + methodName + "\nProduct: " + "Sybase" + "\nVersion: " + versionName + "\nException: " + e.toString() + "\nDescription: The exception is thrown in the test case";
    }

    public void tearDown() {
        this.expectedMaxPrecision = 0;
        this.expectedMaxLength = 0;
        this.expectedIdentifierLength = 0;
        this.actualIdentifierLength = 0;
        this.productVersion = null;
        this.dataType = null;
        this.dataTypeList = null;
        this.definitionCollection = new ArrayList();
        this.dbInformationCollection = new ArrayList();
        this.strProductVersion = null;
        this.definition = null;
        this.typeDefinition = null;
        this.procedure = null;
    }
}

