/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.edit;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11EndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.dialogs.W11BrowseComponentDialog;
import org.eclipse.wst.wsdl.ui.internal.dialogs.W11NewComponentDialog;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLSetComponentHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;

public class W11BindingReferenceEditManager
implements ComponentReferenceEditManager {
    protected W11Description description;
    protected IFile iFile;
    static /* synthetic */ Class class$0;

    public W11BindingReferenceEditManager(W11Description description, IFile iFile) {
        this.description = description;
        this.iFile = iFile;
    }

    public IComponentDialog getBrowseDialog() {
        return new W11BrowseComponentDialog(IWSDLSearchConstants.BINDING_META_NAME, this.iFile, this.description);
    }

    public IComponentDialog getNewDialog() {
        return new W11NewComponentDialog(IWSDLSearchConstants.BINDING_META_NAME, this.iFile, this.description);
    }

    private Definition getDefinition() {
        return (Definition)this.description.getTarget();
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification referencedComponent) {
        W11EndPoint w11EndPoint = (W11EndPoint)referencingObject;
        Object bindingObject = referencedComponent.getObject();
        if (bindingObject instanceof ComponentSpecification) {
            Port port = (Port)w11EndPoint.getTarget();
            WSDLSetComponentHelper helper = new WSDLSetComponentHelper(this.iFile, this.getDefinition());
            helper.setWSDLComponent((WSDLElement)port, "binding", (ComponentSpecification)bindingObject);
        } else if (bindingObject instanceof IBinding) {
            IBinding binding = (IBinding)bindingObject;
            Command command = w11EndPoint.getSetBindingCommand(binding);
            IEditorPart iEditorPart = ASDEditorPlugin.getActiveEditor();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CommandStack stack = (CommandStack)iEditorPart.getAdapter((Class)clazz);
            stack.execute(command);
        }
    }

    public IComponentDescriptionProvider getComponentDescriptionProvider() {
        return null;
    }

    public ComponentSpecification[] getQuickPicks() {
        ArrayList<ComponentSpecification> specList = new ArrayList<ComponentSpecification>();
        Iterator bindings = this.description.getBindings().iterator();
        while (bindings.hasNext()) {
            IBinding binding = (IBinding)bindings.next();
            String qualifier = "";
            String name = binding.getName();
            IFile file = null;
            ComponentSpecification spec = new ComponentSpecification(qualifier, name, file);
            spec.setObject((Object)binding);
            specList.add(spec);
        }
        ComponentSpecification[] specArray = new ComponentSpecification[specList.size()];
        specList.toArray(specArray);
        return specArray;
    }

    public ComponentSpecification[] getHistory() {
        ComponentSpecification[] history = new ComponentSpecification[]{};
        return history;
    }

    public void addToHistory(ComponentSpecification component) {
    }
}

