/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;

public final class TypeUtil {
    static IType resolveType(IType owningType, String typeSignature) {
        if (typeSignature.charAt(0) == 'L' || Signature.getTypeSignatureKind((String)typeSignature) == 4 && Signature.getElementType((String)typeSignature).charAt(0) == 'L') {
            IType type = null;
            try {
                type = owningType.getJavaProject().findType(TypeUtil.getFullyQualifiedName(typeSignature));
            }
            catch (JavaModelException javaModelException) {}
            return type;
        }
        return TypeUtil.resolveTypeRelative(owningType, typeSignature);
    }

    public static String resolveTypeSignature(IType owningType, String typeSignature) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSignature);
        switch (sigKind) {
            case 2: {
                return typeSignature;
            }
            case 4: {
                String elementType = Signature.getElementType((String)typeSignature);
                if (Signature.getTypeSignatureKind((String)elementType) == 2) {
                    return typeSignature;
                }
                String resolvedElementType = TypeUtil.resolveSignatureRelative(owningType, elementType);
                String resultType = "";
                int i = 0;
                while (i < Signature.getArrayCount((String)typeSignature)) {
                    resultType = String.valueOf(resultType) + '[';
                    ++i;
                }
                return String.valueOf(resultType) + resolvedElementType;
            }
            case 1: {
                return TypeUtil.resolveSignatureRelative(owningType, typeSignature);
            }
        }
        return typeSignature;
    }

    private static String resolveSignatureRelative(IType owningType, String typeSignature) {
        String adjustedTypeSignature = typeSignature;
        if (adjustedTypeSignature.charAt(0) == 'L') {
            return typeSignature;
        }
        IType resolvedType = TypeUtil.resolveTypeRelative(owningType, adjustedTypeSignature);
        if (resolvedType != null) {
            String resolvedTypeSignature = Signature.createTypeSignature((String)resolvedType.getFullyQualifiedName(), (boolean)true);
            return resolvedTypeSignature;
        }
        if (Signature.getTypeSignatureKind((String)typeSignature) == 1) {
            JSFCorePlugin.log(new Exception("Failed to resolve type: " + typeSignature), "Failed to resolve type: " + typeSignature);
        }
        return typeSignature;
    }

    private static IType resolveTypeRelative(IType owningType, String typeSignature) {
        String fullName = TypeUtil.getFullyQualifiedName(typeSignature);
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            resolvedType = resolved != null && resolved.length > 0 ? owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]) : TypeUtil.resolveInParents(owningType, fullName);
        }
        catch (JavaModelException javaModelException) {}
        return resolvedType;
    }

    public static String getSignature(IType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        return Signature.createTypeSignature((String)fullyQualifiedName, (boolean)true);
    }

    public static String resolveMethodSignature(IType owner, String unresolvedSignature) {
        String[] parameters = Signature.getParameterTypes((String)unresolvedSignature);
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = TypeUtil.resolveTypeSignature(owner, parameters[i]);
            ++i;
        }
        String resolvedReturn = TypeUtil.resolveTypeSignature(owner, Signature.getReturnType((String)unresolvedSignature));
        return Signature.createMethodSignature((String[])parameters, (String)resolvedReturn);
    }

    private static String getFullyQualifiedName(String typeSignature) {
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        return "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
    }

    private static IType resolveInParents(IType childType, String fullyQualifiedName) throws JavaModelException {
        IType resolvedType = null;
        ITypeHierarchy typeHierarchy = childType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] superTypes = typeHierarchy.getAllSupertypes(childType);
        int i = 0;
        while (i < superTypes.length) {
            IType type = superTypes[i];
            String[][] resolved = type.resolveType(fullyQualifiedName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = childType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
                break;
            }
            ++i;
        }
        return resolvedType;
    }
}

