/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jst.jsf.facesconfig.common.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditorContextMenuProvider;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditorOutlinePage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowPaletteRoot;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowTemplateTransferDropTargetListener;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.ResourceTransferDropTargetListener;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.action.AlignmentAction;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.action.OpenEditorAction;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.action.ShowPropertyViewAction;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.PreExecuteCommandStack;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.ConfigurableRootEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IConnectionPreference;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IFigurePreference;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.ILayerPanePreference;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.INodePreference;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowEditPartsFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowNodeEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFTransformer;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.EditPartMarkerUtil;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowAnnotationUtil;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowModelManager;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowResourceFactory;
import org.eclipse.jst.jsf.facesconfig.ui.preference.GEMPreferences;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class PageflowEditor
extends GraphicalEditorWithFlyoutPalette
implements IAdaptable,
IPropertyChangeListener,
IGotoMarker {
    private static final Logger log;
    private static final String PAGEFLOW_CONTEXTMENU_REG_ID = ".pageflow.editor.contextmenu";
    private final DefaultEditDomain domain;
    private PaletteRoot paletteRoot = null;
    private IEditorPart parentEditor = null;
    private GraphicalViewer viewer = null;
    private PropertySheetPage undoablePropertySheetPage = null;
    private ActionRegistry actionRegistry = null;
    public static final String PAGE_ID = "org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor";
    private List editPartActionIDs = new ArrayList();
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            PageflowEditor.this.updateActions();
        }
    };
    private SelectionSynchronizer synchronizer = null;
    private KeyHandler sharedKeyHandler = null;
    private PageflowModelManager pageflowManager;
    private boolean isDirty = false;
    private CommandStack commandStack;
    private FC2PFTransformer modelsTransform;
    List stackActions = new ArrayList();
    private ResourceTracker resourceTracker = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName(PAGE_ID);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = EditorPlugin.getLogger(clazz);
    }

    public FC2PFTransformer getModelsTransform() {
        if (this.modelsTransform == null) {
            this.modelsTransform = new FC2PFTransformer();
        }
        return this.modelsTransform;
    }

    public void updateActions() {
        this.updateActions(this.stackActions);
        this.updateActions(this.editPartActionIDs);
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
        }
    }

    protected void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public PageflowEditor(IEditorPart parent) {
        this.domain = new DefaultEditDomain(parent);
        this.domain.setCommandStack(this.getCommandStack());
        this.setEditDomain(this.domain);
        this.parentEditor = parent;
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActions.add(action.getId());
    }

    protected void createActions() {
        this.addEditPartAction((SelectionAction)new DeleteAction((IWorkbenchPart)this));
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditPartAction(new OpenEditorAction((IWorkbenchPart)this));
        ShowPropertyViewAction action = new ShowPropertyViewAction((IWorkbenchPart)this);
        action.setImageDescriptor(this.getImageDescriptorForView("org.eclipse.ui.views.PropertySheet"));
        this.addEditPartAction(action);
        this.addEditPartAction(new AlignmentAction((IWorkbenchPart)this, 1));
        this.addEditPartAction(new AlignmentAction((IWorkbenchPart)this, 4));
        this.addEditPartAction(new AlignmentAction((IWorkbenchPart)this, 8));
        this.addEditPartAction(new AlignmentAction((IWorkbenchPart)this, 32));
        this.addEditPartAction(new AlignmentAction((IWorkbenchPart)this, 2));
        this.addEditPartAction(new AlignmentAction((IWorkbenchPart)this, 16));
        ZoomInAction zoomIn = new ZoomInAction(this.getZoomManager(this.getGraphicalViewer()));
        ZoomOutAction zoomOut = new ZoomOutAction(this.getZoomManager(this.getGraphicalViewer()));
        this.addAction((IAction)zoomIn);
        this.addAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
    }

    private ZoomManager getZoomManager(GraphicalViewer viewer) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        ZoomManager zoomManager = null;
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            zoomManager = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
        } else if (rootEditPart instanceof ScalableRootEditPart) {
            zoomManager = ((ScalableRootEditPart)rootEditPart).getZoomManager();
        }
        return zoomManager;
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void createGraphicalViewer(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.viewer.getControl().setBackground(parent.getBackground());
        this.viewer.setRootEditPart((RootEditPart)new ConfigurableRootEditPart());
        this.viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(this.viewer));
        this.registerEditPartViewer((EditPartViewer)this.viewer);
        this.configureEditPartViewer((EditPartViewer)this.viewer);
        this.viewer.setEditPartFactory((EditPartFactory)new PageflowEditPartsFactory());
        this.viewer.addDropTargetListener((TransferDropTargetListener)new ResourceTransferDropTargetListener((EditPartViewer)this.viewer, this.getParentEditor()){

            protected CreationFactory getFactory(Object obj) {
                return PageflowEditor.this.getResourceFactory((IResource)obj);
            }
        });
        EditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected CreationFactory getResourceFactory(IResource resource) {
        return new PageflowResourceFactory(resource);
    }

    public final void doSave(IProgressMonitor monitor) {
        this.getParentEditor().doSave(monitor);
    }

    public final void doSaveAs() {
        this.getParentEditor().doSaveAs();
    }

    public void doSave(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        ((FileEditorInput)this.getEditorInput()).getFile();
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask(String.valueOf(PageflowMessages.Pageflow_Label_Saving) + " " + file.getFullPath(), 2);
        if (this.getPageflowManager() == null) {
            EditorPlugin.getAlerts().throwCoreException("Pageflow.PageflowEditor.Alert.nullModelManager");
        }
        try {
            this.getPageflowManager().save(this.getPageflowFilePath(file));
            progressMonitor.worked(1);
            file.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            progressMonitor.done();
            this.setDirty(false);
        }
        catch (FileNotFoundException e) {
            EditorPlugin.getAlerts().throwCoreException((Throwable)e);
        }
        catch (IOException e) {
            EditorPlugin.getAlerts().throwCoreException((Throwable)e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IFile fileFacesConfig = null;
        try {
            fileFacesConfig = ((FileEditorInput)input).getFile();
            if (this.createPageflow(this.getPageflowFilePath(fileFacesConfig)) == null) {
                log.error("Pageflow.PageflowEditor.Error.invalidPageflowFile");
                throw new PartInitException(EditorPlugin.getResourceString("Pageflow.PageflowEditor.Error.invalidPageflowFile"));
            }
        }
        catch (CoreException e) {
            log.error("Pageflow.PageflowEditor.Error.invalidPageflowFile", (Throwable)e);
            throw new PartInitException(e.getStatus());
        }
        catch (IOException e) {
            log.error("Pageflow.PageflowEditor.Alert.errorSaveFileInfo", (Throwable)e);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
        fileFacesConfig.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
    }

    public void dispose() {
        this.getModelsTransform().dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getSelectionListener());
        EditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.getEditorInput() != null) {
            IFile file;
            IEditorInput iEditorInput = this.getEditorInput();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)iEditorInput.getAdapter((Class)clazz)) != null) {
                file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            }
        }
        super.dispose();
    }

    private IPath getPageflowFilePath(IFile file) {
        IPath pageflowFilePath = PageflowModelManager.makePageflowPath(file.getFullPath());
        return pageflowFilePath;
    }

    private Pageflow createPageflow(IPath pathPageflow) throws CoreException, IOException {
        Pageflow pageflow = null;
        try {
            this.getPageflowManager().load(pathPageflow);
        }
        catch (Exception exception) {
            this.getPageflowManager().createPageflow(pathPageflow);
        }
        IFile fileFacesConfig = ((FileEditorInput)this.getEditorInput()).getFile();
        if (!fileFacesConfig.getFullPath().toString().trim().equalsIgnoreCase(this.getPageflowManager().getModel().getConfigfile())) {
            this.getPageflowManager().getModel().setConfigfile(fileFacesConfig.getFullPath().toString());
            this.getPageflowManager().save(pathPageflow);
        }
        if ((pageflow = this.getPageflowManager().getModel()) == null) {
            log.error("Pageflow.PageflowEditor.Error.invalidPageflowModel");
            EditorPlugin.getAlerts().throwCoreException("Pageflow.PageflowEditor.Error.invalidPageflowModel");
        }
        return pageflow;
    }

    public PageflowModelManager getPageflowManager() {
        if (this.pageflowManager == null) {
            this.pageflowManager = new PageflowModelManager();
        }
        return this.pageflowManager;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final CommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = new PreExecuteCommandStack();
            this.commandStack.addCommandStackEventListener((CommandStackEventListener)new PageCommandStackListener());
        }
        return this.commandStack;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = new PageflowPaletteRoot();
        }
        return this.paletteRoot;
    }

    public final boolean isSaveAsAllowed() {
        return this.getParentEditor().isSaveAsAllowed();
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    protected final IEditorPart getParentEditor() {
        return this.parentEditor;
    }

    public final DefaultEditDomain getEditDomain() {
        return this.domain;
    }

    protected void registerEditPartViewer(EditPartViewer viewer) {
        this.getEditDomain().addViewer(viewer);
        this.getSelectionSynchronizer().addViewer(viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    protected void configureEditPartViewer(EditPartViewer viewer) {
        ActionRegistry actionRegistry;
        if (viewer.getKeyHandler() != null) {
            viewer.getKeyHandler().setParent(this.getSharedKeyHandler());
        }
        this.createActions();
        IEditorPart iEditorPart = this.getParentEditor();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((actionRegistry = (ActionRegistry)iEditorPart.getAdapter((Class)clazz)) != null) {
            Iterator iter = actionRegistry.getActions();
            while (iter.hasNext()) {
                this.getActionRegistry().registerAction((IAction)iter.next());
            }
        }
        PageflowEditorContextMenuProvider provider = new PageflowEditorContextMenuProvider(viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(String.valueOf(EditorPlugin.getPluginId()) + PAGEFLOW_CONTEXTMENU_REG_ID, (MenuManager)provider, this.getSite().getSelectionProvider());
        viewer.addDropTargetListener((TransferDropTargetListener)new PageflowTemplateTransferDropTargetListener(viewer));
    }

    public Pageflow getPageflow() {
        return this.getPageflowManager().getModel();
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.viewer;
    }

    public void setGraphicalViewerContents(Object contents) {
        this.viewer.setContents(contents);
        this.propertyChange(null);
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.getOutlinePage();
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.getCommandStack();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.getActionRegistry();
        }
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            return this.getPropertySheetPage();
        }
        Class<?> clazz5 = class$6;
        if (clazz5 == null) {
            try {
                clazz5 = class$6 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            return this.getZoomManager(this.getGraphicalViewer());
        }
        return super.getAdapter(type);
    }

    protected PageflowEditorOutlinePage getOutlinePage() {
        PageflowEditorOutlinePage outlinePage = new PageflowEditorOutlinePage((EditorPart)this);
        outlinePage.initialize(this);
        return outlinePage;
    }

    protected IPropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.gef.commands.CommandStack");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.undoablePropertySheetPage.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry((CommandStack)this.getAdapter(clazz)));
        }
        return this.undoablePropertySheetPage;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected KeyHandler getSharedKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected ISelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event == null ? null : event.getProperty();
        this.propagateProperty(property, (EditPart)this.viewer.getRootEditPart());
    }

    private void propagateProperty(String property, EditPart part) {
        EditPart child;
        this.processPropertyChange(property, part);
        if (part instanceof GraphicalEditPart) {
            Iterator iterConns = ((GraphicalEditPart)part).getSourceConnections().iterator();
            while (iterConns.hasNext()) {
                child = (EditPart)iterConns.next();
                this.propagateProperty(property, child);
            }
        }
        Iterator iter = part.getChildren().iterator();
        while (iter.hasNext()) {
            child = (EditPart)iter.next();
            this.propagateProperty(property, child);
        }
    }

    private void processPropertyChange(String property, EditPart part) {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        if (property != null && property.equals("UseSystemColors")) {
            property = null;
        }
        if (property == null || "SnapToGrid".equals(property)) {
            boolean bSnapToGrid = store.getBoolean("SnapToGrid");
            if (part instanceof ILayerPanePreference) {
                ((ILayerPanePreference)part).setGridVisible(bSnapToGrid);
            }
        }
        if (property == null || "GridWidth".equals(property) || "GridHeight".equals(property)) {
            Dimension gridSpacing = new Dimension(store.getInt("GridWidth"), store.getInt("GridHeight"));
            if (part instanceof ILayerPanePreference) {
                ((ILayerPanePreference)part).setGridSpacing(gridSpacing);
            }
        }
        if (property == null || "GridColor".equals(property)) {
            Color gridFgColor = GEMPreferences.getColor(store, "GridColor");
            if (part instanceof ILayerPanePreference) {
                ((ILayerPanePreference)part).setGridForegroundColor(gridFgColor);
            }
        }
        if (property == null || "CanvasColor".equals(property)) {
            Color containerBgColor = GEMPreferences.getColor(store, "CanvasColor");
            if (part instanceof IFigurePreference) {
                ((IFigurePreference)part).setBackgroundColor(containerBgColor);
            }
        }
        if (property == null || "LineWidth".equals(property)) {
            int linkLineWidth = store.getInt("LineWidth");
            if (part instanceof IConnectionPreference) {
                ((IConnectionPreference)part).setLineWidth(linkLineWidth);
            }
        }
        if (property == null || "LineColor".equals(property)) {
            Color linkLineColor = GEMPreferences.getColor(store, "LineColor");
            if (part instanceof IConnectionPreference) {
                ((IConnectionPreference)part).setForegroundColor(linkLineColor);
            }
        }
        if (property == null || "ShowLineLabels".equals(property)) {
            boolean bLinkLabelVisible = store.getBoolean("ShowLineLabels");
            if (part instanceof IConnectionPreference) {
                ((IConnectionPreference)part).setLabelVisible(bLinkLabelVisible);
            }
        }
        if (property == null || "LineLabelFont".equals(property) || "LineLabelFontColor".equals(property)) {
            Font linkLabelFont = this.getLinkLabelFont();
            Color linkLabelFgColor = GEMPreferences.getColor(store, "LineLabelFontColor");
            if (part instanceof IConnectionPreference) {
                ((IConnectionPreference)part).setFont(linkLabelFont);
                ((IConnectionPreference)part).setLabelForegroundColor(linkLabelFgColor);
            }
        }
        if (property == null || "LineLabelColor".equals(property)) {
            Color linkLabelBgColor = GEMPreferences.getColor(store, "LineLabelColor");
            if (part instanceof IConnectionPreference) {
                ((IConnectionPreference)part).setLabelBackgroundColor(linkLabelBgColor);
            }
        }
        if (property == null || "LineRouting".equals(property)) {
            String connectionStyle = store.getString("LineRouting");
            int style = "Manhattan".equals(connectionStyle) ? 1 : 0;
            if (part instanceof ILayerPanePreference) {
                ((ILayerPanePreference)part).setConnectionRouterStyle(style);
            } else if (part instanceof IConnectionPreference) {
                ((IConnectionPreference)part).setConnectionRouterStyle(style);
            }
        }
        if (property == null || "FigureLabelFont".equals(property) || "FigureLabelFontColor".equals(property)) {
            Font nodeLabelFont = this.getNodeLabelFont();
            Color nodeLabelFgColor = GEMPreferences.getColor(store, "FigureLabelFontColor");
            if (part instanceof INodePreference) {
                ((INodePreference)part).setFont(nodeLabelFont);
                ((INodePreference)part).setForegroundColor(nodeLabelFgColor);
            }
        }
        if (property == null || "LabelPlacement".equals(property)) {
            int placement = 4;
            String nodeLabelPlacement = store.getString("LabelPlacement");
            if ("Top".equals(nodeLabelPlacement)) {
                placement = 1;
            } else if ("Bottom".equals(nodeLabelPlacement)) {
                placement = 4;
            } else if ("Left".equals(nodeLabelPlacement)) {
                placement = 8;
            } else if ("Right".equals(nodeLabelPlacement)) {
                placement = 16;
            }
            if (part instanceof INodePreference) {
                ((INodePreference)part).setTextPlacement(placement);
            }
        }
    }

    private Font getLinkLabelFont() {
        IPreferenceStore store;
        FontData fontData;
        FontRegistry registry = JFaceResources.getFontRegistry();
        if (!registry.get((fontData = PreferenceConverter.getFontData((IPreferenceStore)(store = EditorPlugin.getDefault().getPreferenceStore()), (String)"LineLabelFont")).toString()).equals((Object)registry.defaultFont())) {
            return registry.get(fontData.toString());
        }
        registry.put(fontData.toString(), new FontData[]{fontData});
        return registry.get(fontData.toString());
    }

    private Font getNodeLabelFont() {
        IPreferenceStore store;
        FontData fontData;
        FontRegistry registry = JFaceResources.getFontRegistry();
        if (!registry.get((fontData = PreferenceConverter.getFontData((IPreferenceStore)(store = EditorPlugin.getDefault().getPreferenceStore()), (String)"FigureLabelFont")).toString()).equals((Object)registry.defaultFont())) {
            return registry.get(fontData.toString());
        }
        registry.put(fontData.toString(), new FontData[]{fontData});
        return registry.get(fontData.toString());
    }

    public void gotoMarker(IMarker marker) {
        GraphicalEditPart part;
        Object id = null;
        try {
            id = marker.getAttribute("location");
        }
        catch (CoreException e) {
            log.error("Pageflow.PageflowEditor.Error.invalidMarkerAttribute", (Throwable)e);
        }
        if (id instanceof String && (part = EditPartMarkerUtil.findEditPart((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart(), (String)id)) != null) {
            this.getGraphicalViewer().reveal((EditPart)part);
            this.getGraphicalViewer().select((EditPart)part);
            return;
        }
    }

    public void webPageChanged(IPath fullPath) {
        PageflowPage page = this.getPageflowManager().foundPage(WebrootUtil.getWebPath((IPath)fullPath));
        if (page != null && this.getGraphicalViewer() != null && this.getGraphicalViewer().getRootEditPart() != null) {
            GraphicalEditPart pagePart = EditPartMarkerUtil.findEditPart((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart(), page.getId());
            PageflowAnnotationUtil.validatePage((PageflowNodeEditPart)pagePart);
        }
    }

    private ImageDescriptor getImageDescriptorForView(String viewid) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.views");
        int i = 0;
        while (i < elements.length) {
            String iconPath;
            String name = elements[i].getName();
            String id = elements[i].getAttribute("id");
            if ("view".equals(name) && viewid.equals(id) && (iconPath = elements[i].getAttribute("icon")) != null) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)elements[i].getDeclaringExtension().getNamespace(), (String)iconPath);
            }
            ++i;
        }
        return null;
    }

    private class PageCommandStackListener
    implements CommandStackEventListener {
        private PageCommandStackListener() {
        }

        public void stackChanged(CommandStackEvent event) {
            if (((CommandStack)event.getSource()).isDirty()) {
                PageflowEditor.this.setDirty(true);
            }
            PageflowEditor.this.updateActions();
        }
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                log.error("Pageflow.PageflowEditor.Error.ResourceChange", (Throwable)exception);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (!(delta.getResource() instanceof IFile)) {
                return true;
            }
            if (WebrootUtil.isValidWebFile((IPath)((IFile)delta.getResource()).getFullPath())) {
                PageflowEditor.this.webPageChanged(((IFile)delta.getResource()).getFullPath());
                return false;
            }
            return false;
        }
    }
}

