/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.sanity;

import junit.framework.TestCase;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.test.util.Activator;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;

public class TestJDTTestEnvironment
extends TestCase {
    private ProjectTestEnvironment _projectTestEnvironment;
    private JDTTestEnvironment _jdtTestEnv;
    private String _testClass1;

    protected void setUp() throws Exception {
        super.setUp();
        this._projectTestEnvironment = new ProjectTestEnvironment("JDTTestProject");
        this._projectTestEnvironment.createProject();
        this._jdtTestEnv = new JDTTestEnvironment(this._projectTestEnvironment);
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(Activator.getDefault().getBundle(), "/testdata/TestClass1.java.data");
        this._testClass1 = codeRes.toString();
    }

    public void testCreateJavaClassFile() {
        ICompilationUnit compUnit = null;
        try {
            compUnit = this._jdtTestEnv.addSourceFile("src", "com.test", "TestClass1", this._testClass1.toString());
        }
        catch (Exception e) {
            TestJDTTestEnvironment.fail((String)e.getLocalizedMessage());
        }
        TestJDTTestEnvironment.assertNotNull(compUnit);
        TestJDTTestEnvironment.assertTrue((boolean)compUnit.exists());
        TestJDTTestEnvironment.assertTrue((boolean)compUnit.getResource().isAccessible());
        try {
            IType type = this._jdtTestEnv.getJavaProject().findType("com.test.TestClass1");
            TestJDTTestEnvironment.assertNotNull((Object)type);
            TestJDTTestEnvironment.assertTrue((type.getMethods().length == 1 ? 1 : 0) != 0);
            TestJDTTestEnvironment.assertTrue((boolean)type.getMethods()[0].getElementName().equals("amethod"));
        }
        catch (JavaModelException jme) {
            TestJDTTestEnvironment.fail((String)jme.getLocalizedMessage());
        }
    }
}

